/* ctype.h,v 1.14 2004/09/04 06:22:16 bird Exp */
/** @file
 *
 * InnoTek LIBC - Character type querying.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@innotek.de>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with This program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _CTYPE_H_
#define	_CTYPE_H_

#include <sys/cdefs.h>
#include <_ctype.h>


__BEGIN_DECLS
int     isalnum(int);
int     isalpha(int);
int     iscntrl(int);
int     isdigit(int);
int     isgraph(int);
int     islower(int);
int     isprint(int);
int     ispunct(int);
int     isspace(int);
int     isupper(int);
int     isxdigit(int);
int     toupper(int);
int     tolower(int);

#if __XSI_VISIBLE
int     _toupper(int);
int     _tolower(int);
int     isascii(int);
int     toascii(int);
#endif

#if __BSD_VISIBLE
/* @todo int	digittoint(int); */
int     isblank(int);
int	ishexnumber(int);
/* @todo int	isideogram(int); */
int	isnumber(int);
/* @todo int	isphonogram(int); */
/* @todo int	isrune(int); */
/* @todo int	isspecial(int); */
#endif
__END_DECLS

#define isalnum(c)  __istype((c), (__UPPER)|(__LOWER)|(__DIGIT))
#define isalpha(c)  __istype((c), (__UPPER)|(__LOWER))
#define iscntrl(c)  __istype((c), (__CNTRL))
#define isgraph(c)  __istype((c), (__PUNCT)|(__UPPER)|(__LOWER)|(__DIGIT))
#define islower(c)  __istype((c), (__LOWER))
#define isprint(c)  __istype((c), (__PRINT))
#define ispunct(c)  __istype((c), (__PUNCT))
#define isspace(c)  __istype((c), (__SPACE))
#define isupper(c)  __istype((c), (__UPPER))
#ifdef __UNIX_CHAR_CLASS__
/* BSD and some other UNIXes have non-standard definitions of these two at least. */
#define isdigit(c)  __isctype((c),(__DIGIT))
#define isxdigit(c) __isctype((c),(__XDIGIT))
#else
#define isdigit(c)  __istype((c),(__DIGIT))
#define isxdigit(c) __istype((c),(__XDIGIT))
#endif
#define tolower(c)  __tolower(c)
#define toupper(c)  __toupper(c)

#if __XSI_VISIBLE
#define _toupper(c) __toupper(c)
#define _tolower(c) __tolower(c)
#define	isascii(c)   (((c) & ~0x7F) == 0)
#define	toascii(c)   ((c) & 0x7F)
#endif

#if __BSD_VISIBLE
#define isblank(c)      __istype((c), (__BLANK))
#define ishexnumber(c)  __istype((c), (__XDIGIT))
#define isnumber(c)     __istype((c), (__DIGIT))
#endif

#endif
