#include <stdio.h>
#include <string.h>
#include <errno.h>

int __libc_back_fsResolve(const char *pszUserPath, unsigned fFlags, char *pszNativePath, int *pfInUnixTree);

/** __libc_back_fsResolve() flags.
 * @{ */
/** Resolves the path up to but not including the last component. */
#define BACKFS_FLAGS_RESOLVE_PARENT     0x1
/** Resolves and verfies the entire path. */
#define BACKFS_FLAGS_RESOLVE_FULL       0x2
/** Resolves and verfies the entire path but it's ok if the last component doesn't exist. */
#define BACKFS_FLAGS_RESOLVE_FULL_MAYBE 0x3
/** @} */


int main (int argc, char *argv[])
{
    char    szNativePath[300];
    int     rc;

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve(".", BACKFS_FLAGS_RESOLVE_FULL, szNativePath, NULL);
    printf("+ '.' -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve("/", BACKFS_FLAGS_RESOLVE_FULL, szNativePath, NULL);
    printf("+ '/' -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve("/tmp", BACKFS_FLAGS_RESOLVE_FULL, szNativePath, NULL);
    printf("+ '/tmp' -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve("/tmp", BACKFS_FLAGS_RESOLVE_PARENT, szNativePath, NULL);
    printf("+ '/tmp' (parent) -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve("/nosuchdir", BACKFS_FLAGS_RESOLVE_PARENT, szNativePath, NULL);
    printf("+ '/nosuchdir' (parent) -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);

    memset(szNativePath, 0xAA, sizeof(szNativePath));
    errno = 0;
    rc = __libc_back_fsResolve("/nosuchdir/nosuchsubdir", BACKFS_FLAGS_RESOLVE_PARENT, szNativePath, NULL);
    printf("- '/nosuchdir/nosuchsubdir' (parent) -> rc=%d errno=%d szNativePath=%s\n", rc, errno, szNativePath);


    return 0;
}

