/* fullpath.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <emx/io.h>
#include <InnoTekLIBC/libc.h>

int _fullpath (char *dst, const char *src, int size)
{
  char drive, cwd1[MAXPATHLEN+1], cwd2[MAXPATHLEN+1];
  char *temp = NULL, c, *r;
  int j, k, add_file;

  /* drive stuff. */
  drive = _fngetdrive (src);
  if (drive == 0)
    drive = _getdrive ();
  else
    src += 2;

  /* save the cwd of the drive */
  if (!_getdcwd(drive - 'A' + 1, cwd1, sizeof(cwd1)))
    goto failure2;

  /* try change to the specified path. */
  add_file = 0; k = 0;
  if (chdir (src) != 0)
    {
      int i = strlen (src);
      temp = (char *)alloca (i+2+1);
      temp[0] = drive; temp[1] = ':';
      strcpy (temp+2, src);

      k = _getname (temp) - temp;
      if (k == 3)
        {
          c = temp[k];
          temp[k] = '\0';
          if (chdir (temp) != 0)
            goto failure;
          temp[k] = c;
        }
      else if (k > 3)
        {
          temp[k-1] = '\0';
          if (chdir (temp) != 0)
            goto failure;
        }
      add_file = 1;
    }

  /* get the changed path. */
  r = _getdcwd(drive - 'A' + 1, cwd2, sizeof(cwd2));
  if (_chdir (cwd1) != 0 || r == NULL)
    goto failure;

  if (strlen (cwd2)+1 > size)
  {
      errno = ERANGE;
      goto failure;
  }
  strcpy (dst, cwd2);
  if (add_file && temp[k] != 0)
    {
      j = strlen (dst);
      if (j+1+strlen (temp+k)+1 > size)
      {
          errno = ERANGE;
          goto failure;
      }
      if (!_trslash (dst, j, 0))
        dst[j++] = !__libc_gfNoUnix ? '/' : '\\';
      strcpy (dst+j, temp+k);
    }

  if (!__libc_gfNoUnix)
    _fnslashify (dst);
  return 0;

failure:
  chdir(cwd1);
failure2:
  dst[0] = '\0';
  return -1;
}
