/* $Id: b_threadInit.c 1618 2004-11-07 14:19:42Z bird $ */
/** @file
 *
 * LIBC SYS Backend - thread structure init.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <os2emx.h>
#include <sys/signal.h>
#include <emx/syscalls.h>
#include "syscalls.h"
#include "signals.h"
#include <InnoTekLIBC/thread.h>
#include <InnoTekLIBC/backend.h>


void __libc_Back_threadInit(__LIBC_PTHREAD pThrd, const __LIBC_PTHREAD pParentThrd)
{
    pThrd->b.sys.fd.hdir = HDIR_CREATE;
    pThrd->b.sys.fd.cFiles = 0;

    /*
     * Gain exclusive access to the signal stuff.
     */
    int rc = __libc_back_signalSemRequest();

    /*
     * Copy signal stuff.
     */
    pThrd->SigSetBlocked    = pParentThrd->SigSetBlocked;
    /** @todo Inheriting fSigSetBlockedOld doesn't make sense! */
    if (pParentThrd->fSigSetBlockedOld)
    {
        pThrd->SigSetBlockedOld     = pParentThrd->SigSetBlockedOld;
        pThrd->fSigSetBlockedOld    = pParentThrd->fSigSetBlockedOld;
    }

    /*
     * Release semaphore.
     */
    if (!rc)
        __libc_back_signalSemRelease();
}

