/* $Id: b_signalVerifyPGrp.c 1614 2004-11-05 02:16:17Z bird $ */
/** @file
 *
 * LIBC SYS Backend - verify process group id for signaling.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#define INCL_BASE
#define INCL_FSMACROS
#include <os2emx.h>

#include <signal.h>
#include <errno.h>
#include <InnoTekLIBC/signals.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_SIGNAL
#include <InnoTekLIBC/logstrict.h>


/**
 * Verify the existance of a process group and that the current process
 * is allowed to signal it.
 *
 * @return 0 on success.
 * @return -ESRCH if pgid doesn't exist.
 * @return -EPERM if we aren't allowed to signal the pgid.
 * @param   pgid    Process group id which the current process intend to signal.
 * @todo    Do EPERM check, no ideas here yet.
 * @remark  This Backend Signal API does NOT require the caller to own the signal semaphore.
 */
int     __libc_back_signalVerifyPGrp(pid_t pgid)
{
    LIBCLOG_ENTER("pgid=%d\n", pgid);
    int     rc;
    FS_VAR();

/** @todo figure out something for process groups. */

    /*
     * Check if the process is around.
     */
    FS_SAVE_LOAD();
    rc = DosVerifyPidTid(pgid, 1);
    FS_RESTORE();
    if (rc)
        LIBCLOG_RETURN_INT(-ESRCH);
    LIBCLOG_RETURN_INT(0);
}


