/* $Id: b_signalWait.c 1614 2004-11-05 02:16:17Z bird $ */
/** @file
 *
 * LIBC SYS Backend - signal wait.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */



/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#define INCL_BASE
#define INCL_FSMACROS
#include <os2emx.h>

#include <signal.h>
#include <errno.h>
#include <386/builtin.h>
#include <InnoTekLIBC/signals.h>
#include <InnoTekLIBC/thread.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_SIGNAL
#include <InnoTekLIBC/logstrict.h>



int         __libc_back_signalWait(const struct timespec *pTimeout)
{
    LIBCLOG_ENTER("pTimeout=%p {tv_sec=%d tv_nsec=%ld}\n",
                  (void *)pTimeout, 
                  pTimeout->tv_sec,
                  pTimeout->tv_nsec);
    /** @todo Implement me */
#if 0
    sigset_t        SigSetPending;

    if (    !__SIGSET_ISEMPTY(&pThrd->SigSetPending)
        ||  !__SIGSET_ISEMPTY(&__libc_gSignalPending))
    {
        __SIGSET_OR(&SigSetPending, &pThrd->SigSetPending, &__libc_gSignalPending);
        __SIGSET_AND(&SigSetPending, &SigSetPending, &SigSet);
        if (!__SIGSET_ISEMPTY(&SigSetPending))
            rc = __libc_back_signalAccept();
    }
#endif 
    LIBCLOG_RETURN_INT(-1);
}

