/* $Id: b_signalSuspend.c 1614 2004-11-05 02:16:17Z bird $ */
/** @file
 *
 * LIBC SYS Backend - suspend till next signal.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#define INCL_BASE
#define INCL_FSMACROS
#include <os2emx.h>

#include <signal.h>
#include <errno.h>
#include <InnoTekLIBC/signals.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_SIGNAL
#include <InnoTekLIBC/logstrict.h>

    
/*******************************************************************************
*   Structures and Typedefs                                                    *
*******************************************************************************/
/** Registration record for signalSuspendXcptHandler(). */
typedef struct XCPTREGREC
{
    EXCEPTIONREGISTRATIONRECORD     Core;
    /** This event semaphore is signaled when a signal has been
     * processed by the current thread. */
    HEV                             hev;
} XCPTREGREC, *PXCPTREGREC;


/*******************************************************************************
*   Internal Functions                                                         *
*******************************************************************************/
static ULONG _System signalSuspendXcptHandler(PEXCEPTIONREPORTRECORD pXcptRec,  PEXCEPTIONREGISTRATIONRECORD pRegRec, PCONTEXTRECORD pCtx, PVOID pvSomething);


/**
 * Exception handler use while waitin for signals to be 
 * delivered to this thread or the process being terminated.
 */
static ULONG _System signalSuspendXcptHandler(PEXCEPTIONREPORTRECORD pXcptRec,  PEXCEPTIONREGISTRATIONRECORD pRegRec, PCONTEXTRECORD pCtx, PVOID pvSomething)
{
    /* a thread counter? */
    /** @todo implement me! */
    return XCPT_CONTINUE_SEARCH;
}


/**
 * Suspends the current thread till a signal have been handled.
 * The signal semaphore is owned.
 */
int         __libc_back_signalSuspend(void)
{
    LIBCLOG_ENTER("\n");
    int         rc;
    XCPTREGREC  XcptReg;
    FS_VAR();

    /*
     * Register 
     */
    FS_SAVE_LOAD();
    XcptReg.Core.ExceptionHandler = signalSuspendXcptHandler;
    XcptReg.Core.prev_structure = (void *)~0;
    rc = DosCreateEventSem(NULL, &XcptReg.hev, 0, FALSE);
    if (!rc)
    {
        rc = DosSetExceptionHandler(&XcptReg.Core);
        if (!rc)
        {
            PPIB    pPib;
            PTIB    pTib;
            
            /*
             * Time to release the semaphore.
             */
            __libc_back_signalSemRelease();
            if (pTib->tib_ptib2->tib2_usMCCount)
            {
                LIBC_ASSERTM_FAILED("Deadlock avoided. tried to wait for signal with must complete count %d\n", pTib->tib_ptib2->tib2_usMCCount);
                LIBCLOG_RETURN_INT(-EDEADLK);
            }

            /*
             * Wait loop.
             */
            DosGetInfoBlocks(&pTib, &pPib);
            for (;;)
            {
                rc = DosWaitEventSem(XcptReg.hev, 30*1000);
                if (!rc)
                    break;

                /* Avoid deadlocks during termination. */
                if (pPib->pib_flstatus & (0x40/*dying*/ | 0x04/*exiting all*/ | 0x02/*Exiting Thread 1*/ | 0x01/* ExitList */))
                {
                    LIBCLOG_MSG("resuming execution, anyhow. the process is terminating. (status=%#lx\n", pPib->pib_flstatus);
                    break;
                }
            }

            DosUnsetExceptionHandler(&XcptReg.Core);
        }
        DosCloseEventSem(XcptReg.hev);
    }

    FS_RESTORE();
    LIBCLOG_RETURN_INT(0);
}


