/* freopen.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <share.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>
#include <emx/io.h>

FILE *_STD(freopen) (const char *fname, const char *mode, FILE *stream)
{
  FILE *result;

  STREAMV_LOCK;
  if (stream->_flags & _IOOPEN)
    { /* duplication of fclose(), but no _closestream lock. */
      int result;
      char buf[L_tmpnam];

      result = EOF;
      if ((stream->_flags & _IOOPEN) && !(stream->_flags & _IOSPECIAL))
        {
          result = 0;
          result = fflush (stream);
          if (close (stream->_handle) < 0)
            result = EOF;
          if (result == 0 && (stream->_flags & _IOTMP))
            {
              _itoa (stream->_tmpidx, buf, 10);
              strcat (buf, ".tmp");
              if (remove (buf) != 0)
                result = EOF;
            }
          if ((stream->_flags & _IOBUFMASK) == _IOBUFLIB)
            free (stream->_buffer);
        }
      _closestream (stream);
    }
  result = _openstream (stream, fname, mode, SH_DENYNO, 0);
  STREAMV_UNLOCK;
  return result;
}
