/* $Id: signals.h 1574 2004-10-10 11:07:40Z bird $ */
/** @file
 *
 * InnoTek LIBC - Signal Internals.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __InnoTekLIBC_signals_h__
#define __InnoTekLIBC_signals_h__

/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
/** @defgroup __libc_back_signalRaise_return    __libc_back_signalRaise() returns.
 * @{ */
/** Try restart any interrupted system call. */
#define __LIBC_BSRR_RESTART     0x01
/** Go ahead interrupt system call in progress. */
#define __LIBC_BSRR_INTERRUPT   0x02
/** If set execution should be resumed. */
#define __LIBC_BSRR_CONTINUE    0x10
/** If set execution should not be resumed but the signal should be passed
 * on to the system. */
#define __LIBC_BSRR_PASSITON    0x20
/** If set the passed in SIGQUEUED structure was used. */
#define __LIBC_BSRR_USED_QUEUED 0x40
/** Failure. */
#define __LIBC_BSRR_ERROR       0xffffff22
/** @} */

/** @defgroup __libc_back_signalRaise_flags     __libc_back_signalRaise() flags.
 * @{ */
/** The signal is thread specific and must be delivered to the current thread. */
#define __LIBC_BSRF_THREAD      0x01
/** The signal was send from an unknown process. */
#define __LIBC_BSRF_EXTERNAL    0x02
/** The signal was generated by the hardware (i.e. CPUs and such). */
#define __LIBC_BSRF_HARDWARE    0x04
/** The signal should be queued. */
#define __LIBC_BSRF_QUEUED      0x08
/** @} */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <sys/cdefs.h>
#include <signal.h>


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** Signal set of the signals which will interrupt system call execution.
 * By default all signals will interrupt syscall execution, since OS/2 can't really
 * restart system calls easily.
 * Update is protected by the signal semaphore, however read access isn't.
 */
extern sigset_t     __libc_gSignalRestartMask;

/** Signal set for the signals which are pending on a process scope.
 * These signals are blocked by all threads and waiting to be delivered
 * to a thread. */
extern sigset_t     __libc_gSignalPending;


__BEGIN_DECLS

int         __libc_back_signalInit(void);
int         __libc_back_signalSemRequest(void);
void        __libc_back_signalSemRelease(void);
unsigned    __libc_back_signalSemIsOwner(void);
void        __libc_back_signalPokeThread(int tid);
void        __libc_back_signalPokeProcess(void);
int         __libc_back_signalSuspend(void);
int         __libc_back_signalWait(const struct timespec *pTimeout);
int         __libc_back_signalVerifyPid(pid_t pid);
int         __libc_back_signalVerifyPGrp(pid_t pgid);
int         __libc_back_signalSendPid(pid_t pid, int iSignalNo);
int         __libc_back_signalSendPGrp(pid_t pgrp, int iSignalNo);
int         __libc_back_signalAction(int iSignalNo, const struct sigaction *pSigAct, struct sigaction *pSigActOld);
unsigned    __libc_back_signalRaise(int iSignalNo, siginfo_t *pSigInfo, void *pvXcptOrQueued, unsigned fFlags);
int         __libc_back_signalRaisePoked(void *pvXcptParams, int tidPoker);

__END_DECLS

#endif
