/* $Id: dlsym.c 1546 2004-10-07 06:42:16Z bird $ */
/** @file
 * dlclose - Close an dlopen'ed dynamic load library.
 *
 * Copyright (c) 2001-2003 knut st. osmundsen <bird@anduin.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with This program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#define INCL_BASE
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <dlfcn.h>

#include "dlfcn_private.h"

/**
 * Find the address of a given symbol within the given library.
 * @returns Address of symbol.
 *          NULL if not found.
 * @param   pvHandle    Module handle returned by dlopen.
 * @param   pszSymbol   Name of the symbol.
 */
void * dlsym(void *pvHandle, const char *pszSymbol)
{
    APIRET  rc;                         /* Return code. */
    PFN     pfn;                        /* Returned symbol pointer. */

    rc = DosQueryProcAddr((HMODULE)pvHandle, (long)pszSymbol < 0x10000 ? (long)pszSymbol : 0, pszSymbol, &pfn);
    dlfcn_enmLastOp     = dlfcn_dlsym;
    dlfcn_ulLastError   = rc;
    if (rc != NO_ERROR)
    {
        dlfcn_szLastError[0] = '\0';
        strncat(dlfcn_szLastError, pszSymbol, sizeof(dlfcn_szLastError));
        return NULL;
    }

    return (void*)pfn;
}

