/* $Id: symlink.c 1534 2004-10-01 04:55:39Z bird $ */
/** @file
 *
 * symlink()
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */



/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_IO
#include <InnoTekLIBC/logstrict.h>


/**
 * Create a symlink.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   target      The target of the symbolic link.
 * @param   symlink     Path to the symbolic link to create.
 */
int	 _STD(symlink)(const char *target, const char *symlink)
{
    LIBCLOG_ENTER("target=%p:{%s} symlink=%p:{%s}\n", (void *)target, target, (void *)symlink, symlink);
    int rc = __libc_Back_fsSymlinkCreate(target, symlink);
    if (!rc)
        LIBCLOG_RETURN_INT(0);
    errno = -rc;
    LIBCLOG_RETURN_INT(-1);
}

