#
# A simple script to collect all symbols from c.a and sys.a that needs
# aliasing. All symbols beginning with _std_ get an alias without _std_
# and an alias starting with just a '_' instead of _std_.
#

function check_file(x)
{
  if ((getline < x) < 0)
  {
    print "ERROR: file "x" not found (maybe you forgot to make it?)" > "/dev/stderr"
    exit (-1);
  }
  close(x);
}

function gulp(fn)
{
  check_file(fn);

  cmd = "nm -gB "fn;
  names[n,0] = 0;

  while ((cmd | getline) > 0)
  {
    if (index("TCBD", $2))
    {
      funcs[$3] = 1;
      if (substr($3, 1, 6) == "__std_")
        stdfuncs[substr($3, 7)] = 1;
    }
  }
  close(cmd);
}

BEGIN {
  gulp("out/dbg/aout/c.a");
  gulp("out/dbg/aout/sys.a");
  gulp("out/dbg/aout/c_app.a");

  prefix = ARGV[1];

  for (x in stdfuncs)
    if (funcs[prefix""x] == "")
      print x;

  exit;
}
