/* $Id: b_ioFHToPath.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * LIBC Backend - __libc_Back_fhToPath().
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <stdlib.h>
#include <errno.h>
#include <math.h>
#include <emx/umalloc.h>
#include <emx/io.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_BACKEND
#include <InnoTekLIBC/logstrict.h>

#define INCL_DOSPROFILE
#define INCL_DOSERRORS
#define INCL_FSMACROS
#include <os2emx.h>



/**
 * Try resolve a filehandle to a path.
 *
 * @returns 0 on success.
 * @returns Negative error code (errno.h) on failure.
 * @param   fh          The file handle.
 * @param   pszPath     Where to store the path.
 * @param   cchPath     The size of he buffer pointed to by pszPath.
 */
int __libc_Back_ioFHToPath(int fh, char *pszPath, size_t cchPath)
{
    LIBCLOG_ENTER("fh=%d pszPath=%p cchPath=%d\n", fh, (void *)pszPath, cchPath);

    /*
     * Get the filehandle structure and check that's is an ordinary file.
     */
    __LIBC_PFH  pFH;
    int rc = __libc_FHEx(fh, &pFH);
    if (rc)
    {
        LIBC_ASSERTM_FAILED("Invalid filehandle %d\n", fh);
        LIBCLOG_RETURN_INT(rc);
    }
    if ((pFH->fFlags & __LIBC_FH_TYPEMASK) != F_FILE)
    {
        LIBC_ASSERTM_FAILED("Filetype %08x is notsupported by this api, filehandle %d\n", pFH->fFlags & __LIBC_FH_TYPEMASK, fh);
        LIBCLOG_RETURN_INT(-ENOSYS);
    }

    /*
     * Now query the SFN number for this file.
     */

    /*
     * Query the filename fromthe SFN entry.
     */

    /** @todo implement this api. */
    LIBC_ASSERTM_FAILED("Not implemented!\n");
    LIBCLOG_RETURN_INT(-ENOSYS);
}

