/* $Id: __fork.s 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * fork() 'syscall'.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 * Copyright (c) 2004 nickk
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <emx/asm386.h>

    .globl  LABEL(__fork)

    .text

/**
 * Save the registers and exception chain before forwarding
 * to __libc_fork().
 *
 * @returns See fork().
 */
LABEL(__fork):
    pushl   %ebp
    movl    %esp, %ebp

    /* Save registers on stack */
    and     $0xfffffff0, %esp           /* fxsave requires 16 byte alignment. */
    subl    $512, %esp
    movl    $0, 0(%esp)                 /* paranoia!!!!!!! touch the stack page preventing faults in fxsave. */
    fxsave  0(%esp)
    pushf
    pushl	%ebx
    pushl	%esi
    pushl	%edi
    pushl   %ebp
    pushl   %gs
    pushl   %fs
    /* load correct fs before accesing the exception chain head. */
    movl    $DosTIB, %eax
    movl    %eax, %fs
    addr16 pushl %fs:0

    /*
     * Call the fork worker.
     */
    movl    %esp, %eax
    pushl	%eax
    pushl   $fork_ret
    call	LABEL(__libc_fork)
    addl	$12, %esp                   /* 12 = 8 + fs:[0]. */
    popl    %fs
    jmp     fork_skip_regs

    /*
     * Child returns here.
     */
ALIGN
fork_ret:
    addr16 popl %fs:0                   /* exception chain */
    popl    %fs
    popl    %gs
    popl    %ebp
    popl    %edi
    popl    %esi
    popl    %ebx
    popf
    fxrstor	0(%esp)

fork_skip_regs:
    mov     %ebp, %esp
    popl    %ebp
    ret

