/* chdir2.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <emx/io.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/backend.h>

int _chdir2 (const char *name)
{
  char old_drive, new_drive;

  old_drive = _getdrive ();
  new_drive = _fngetdrive (name);
  if (new_drive != 0)
    {
      if (_chdrive (new_drive) != 0)
        return -1;
      if (name[2] == 0)         /* Change drive only */
        return 0;
    }
  int rc = __libc_Back_fsDirCurrentSet (name);
  if (rc == 0)
    return 0;
  else
    {
      _chdrive (old_drive);
      errno = -rc;
      return -1;
    }
}
