/* abspath.c (emx+gcc) -- Copyright (c) 1992-1998 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <alloca.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/libc.h>
#include <InnoTekLIBC/locale.h>
#include <InnoTekLIBC/backend.h>

#define FALSE   0
#define TRUE    1
#define IS_PATH_DELIM(c) ((c)=='\\' || (c)=='/')

int _abspath (char *dst, const char *src, int size)
{
  char drive, dir[MAXPATHLEN+1], src_drive, *s, *p;
  int i, j, rel, server, trail, mbcl;
  char chSlash = !__libc_gfNoUnix ? '/' : '\\';

  s = alloca (strlen (src) + 1);
  strcpy (s, src);
  src_drive = _fngetdrive (s);
  if (src_drive == 0)
    drive = _getdrive ();
  else
    {
      drive = src_drive;
      s += 2;
    }
  dir[0] = 0; rel = FALSE; server = FALSE; trail = FALSE;
  if (IS_PATH_DELIM (*s))
    {
      ++s;
      if (IS_PATH_DELIM (*s))
        {
          ++s; server = TRUE;
        }
    }
  else if (__libc_Back_fsDirCurrentGet (dir, sizeof(dir), src_drive, __LIBC_BACK_FSCWD_NO_DRIVE | __LIBC_BACK_FSCWD_NO_ROOT_SLASH) == 0)
    {
      if (!__libc_gfNoUnix)
        _fnslashify (dir);
    }
  else
    {
      dir[0] = 0;
      rel = TRUE;
    }

  while (*s != 0)
    {
      if (s[0] == '.' && (IS_PATH_DELIM (s[1]) || s[1] == 0))
        ++s;
      else if (s[0] == '.' && s[1] == '.' && (IS_PATH_DELIM (s[2]) ||
                                              s[2] == 0))
        {
          s += 2;
          if (*dir == 0)
            strcpy (dir, "..");
          else
            {
              p = _getname (dir);
              if (p == dir)
                p[0] = 0;
              else
                p[-1] = 0;
            }
        }
      else
        {
          i = strlen (dir);
          if (i < sizeof (dir) - 1)
            dir[i++] = chSlash;
          while (*s != 0)
            {
              if (CHK_MBCS_PREFIX (&__libc_GLocaleCtype, *s, mbcl) && s[1] != 0)
                {
                  if (i < sizeof (dir) - mbcl)
                    {
                      memcpy (dir + i, s, mbcl);
                      i += mbcl;
                    }
                  s += mbcl;
                }
              else if (IS_PATH_DELIM (*s))
                break;
              else
                {
                  if (i < sizeof (dir) - 1)
                    dir[i++] = *s;
                  ++s;
                }
            }
          dir[i] = 0;
        }
      if (*s != 0)
        {
          ++s;
          if (*s == 0)
            trail = 1;
        }
    }
  i = 0;
  if (i+1 < size && (src_drive != 0 || !server))
    {
      dst[i++] = drive;
      dst[i++] = ':';
    }
  if (i < size && server && src_drive == 0)
    dst[i++] = chSlash;
  if (i < size && !rel && dir[0] != chSlash)
    dst[i++] = chSlash;
  j = 0;
  if (rel && dir[j] == chSlash)
    ++j;
  while (i < size && dir[j] != 0)
    dst[i++] = dir[j++];
  if (trail && i < size && (i == 0 || dst[i-1] != chSlash))
    dst[i++] = chSlash;
  if (i >= size)
    {
      dir[size-1] = 0;
      errno = ERANGE;
      return -1;
    }
  dst[i] = 0;
  return 0;
}
