/* $Id: _getdcwd.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * VAC/MSC interface.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <direct.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MISC
#include <InnoTekLIBC/logstrict.h>


/**
 * Gets the full path of the current directory of a specific drive.
 *
 * @returns pszBuffer or pointer to an malloc'ed buffer containing the requested path.
 * @returns NULL and errno on failure.
 * @param   iDrive      Which drive to get the current directory of. This is 1-based,
 *                      meaning that A is 1, B is 2, and so on. 0 will return the
 *                      current directory of the current drive (which can be the unix root!).
 * @param   pszBuffer   Where to store the current directory of the drive.
 *                      If NULL a buffer will be malloc'ed. The size of the malloc'ed
 *                      buffer will be cchBuffer and if cchBuffer is 0 it will be
 *                      as big as necessary.
 * @param   cchBuffer   Size of the buffer.
 */
char *_getdcwd(int iDrive, char *pszBuffer, int cchBuffer)
{
    LIBCLOG_ENTER("iDrive=%d pszBuffer=%p cchBuffer=%d\n", iDrive, (void *)pszBuffer, cchBuffer);
    char chDrive = iDrive ? iDrive + 'A' - 1 : 0;

    int rc;
    if (!pszBuffer)
    {
        LIBCLOG_MSG("Allocating buffer, %d bytes.\n", cchBuffer ? cchBuffer : PATH_MAX);
        size_t cch = cchBuffer ? cchBuffer : PATH_MAX;
        pszBuffer = malloc(cch);
        if (pszBuffer)
        {
            rc = __libc_Back_fsDirCurrentGet(pszBuffer, cchBuffer, chDrive, 0);
            if (!rc)
            {
                /*
                 * Reallocate a PATH_MAX buffer before we return.
                 */
                if (!cchBuffer)
                {
                    char *pvOld = pszBuffer;
                    cch = strlen(pszBuffer) + 1;
                    pszBuffer = realloc(pszBuffer, cch > cchBuffer ? cch : cchBuffer);
                    if (!pszBuffer)
                        pszBuffer = pvOld;
                }
                LIBCLOG_RETURN_MSG(pszBuffer, "ret %p:{%s}\n", (void *)pszBuffer, pszBuffer);
            }
            free(pszBuffer);
        }
        else
            rc = -ENOMEM;
    }
    else
    {
        rc = __libc_Back_fsDirCurrentGet(pszBuffer, cchBuffer, chDrive, 0);
        if (!rc)
            LIBCLOG_RETURN_MSG(pszBuffer, "ret %p:{%s}\n", (void *)pszBuffer, pszBuffer);
    }

    errno = -rc;
    LIBCLOG_RETURN_P(NULL);
}

