/* $Id: _heapvoting.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * Voting on default heap in High or Low memory.
 *
 * Copyright (c) 2003 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <emx/umalloc.h>


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** The voting result. */
static enum { enmHigh = 0, enmLow = 1, enmResultLow = 2, enmResultHigh = 4 }
    enmResult = enmHigh;


/**
 * Place a vote for which heap to use as default.
 *
 * @param   fDefaultHeapInHighMem
 */
void    __libc_HeapVote(int fDefaultHeapInHighMem)
{
    if (enmResult < enmResultLow)
    {
        if (!fDefaultHeapInHighMem)
            enmResult = enmLow;
    }
}


/**
 * End the voting.
 */
void    __libc_HeapEndVoting(void)
{
    if (enmResult < enmResultLow)
        enmResult = (enmResult == enmHigh) ? enmResultHigh : enmResultLow;
#ifdef DEBUG
    else { __asm__ (" int $3"); }
#endif
}


/**
 * Asks what the result of the voting were.
 *
 * @returns 0 if to use the low memory heap.
 * @returns 1 if to use the high memory heap.
 * @returns -1 if the voting isn't finished yet.
 */
int     __libc_HeapGetResult(void)
{
    if (enmResult < enmResultLow)
        return -1;
    return (enmResult == enmResultHigh);
}

