/* stat.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <io.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <emx/io.h>
#include <emx/time.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/backend.h>

int _STD(stat) (const char *name, struct stat *buffer)
{
  int rc = __libc_Back_fsFileStat (name, buffer);
  if (rc == 0)
    {
      if (!_tzset_flag)
        tzset ();
      _loc2gmt (&buffer->st_atime, -1);
      _loc2gmt (&buffer->st_mtime, -1);
      _loc2gmt (&buffer->st_ctime, -1);
      if ((buffer->st_mode & (S_IFMT | ((S_IEXEC >> 6) * 0111))) == S_IFREG)
        {
          const char *tmp = _getext (name);
          if (tmp != NULL &&
              (stricmp (tmp, ".exe") == 0 ||
               stricmp (tmp, ".com") == 0 ||
               stricmp (tmp, ".cmd") == 0 ||
               stricmp (tmp, ".bat") == 0))
            buffer->st_mode |= (S_IEXEC >> 6) * 0111;
        }
    }
  else
    {
      errno = -rc;
      rc = -1;
    }
  return rc;
}
