/* $Id: fchown.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * fchown()
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */



/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <unistd.h>
#include <emx/io.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_IO
#include <InnoTekLIBC/logstrict.h>



/**
 * Change the owner and group over a file.
 *
 * This is stub. It only validates the filehandle and returns without changing anything.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   fh      Handle to the file.
 * @param   owner   Owner id.
 * @param   group   Group id.
 */
int	 _STD(fchown)(int fh, uid_t owner, gid_t group)
{
    LIBCLOG_ENTER("fh=%d owner=%d group=%d\n", fh, owner, group);
    __LIBC_PFH  pFH = __libc_FH(fh);
    if (pFH)
        LIBCLOG_RETURN_INT(0);
    LIBCLOG_RETURN_INT(-1);
}


