/* $Id: b_fsDirCurrentSet.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * LIBC SYS Backend - chdir.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@innotek.de>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include "fs.h"
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_BACK_FS
#include <InnoTekLIBC/logstrict.h>


/**
 * Changes the current directory of the process.
 *
 * @returns 0 on success.
 * @returns Negative error code (errno.h) on failure.
 * @param   pszPath     Path to the new current directory of the process.
 */
int __libc_Back_fsDirCurrentSet(const char *pszPath)
{
    LIBCLOG_ENTER("pszPath=%p:{%s}\n", (void *)pszPath, pszPath);
    FS_VAR();

    /*
     * Lock the fs global state.
     */
    int rc = __libc_back_fsMutexRequest();
    if (rc)
        LIBCLOG_RETURN_INT(rc);

    /*
     * Resolve the specified file path.
     */
    int     fInUnixTree;
    char    szNativePath[PATH_MAX];
    rc = __libc_back_fsResolve(pszPath, BACKFS_FLAGS_RESOLVE_FULL, &szNativePath[0], &fInUnixTree);
    if (!rc)
    {
        /*
         * Change the current directory.
         *
         * If we change into or out of the unix root, we must make sure the
         * default disk is changed too. This means that we keep the OS/2
         * semantics of chdir() when not in the unix comparement, with the
         * obvious exception of root relative paths.
         */
        FS_SAVE_LOAD();
        int rc = DosSetCurrentDir((PCSZ)&szNativePath[0]);
        FS_RESTORE();
        if (!rc)
        {
            if (__libc_gcchUnixRoot)
            {
                if (fInUnixTree != __libc_gfInUnixTree)
                {
                    ULONG ulDrive = szNativePath[0] - (szNativePath[0] >= 'A' && szNativePath[0] <= 'Z' ? 'A' - 1 : 'a' -1);
                    rc = DosSetDefaultDisk(ulDrive);
                    LIBC_ASSERTM(!rc, "DosSetDefaultDisk(%ld) -> %d. unix drive is %c\n", ulDrive, rc, szNativePath[0]);
                    rc = 0;             /* ignore this kind of errors. */
                }
                __libc_gfInUnixTree = fInUnixTree;
            }
        }
        else
            rc = -__libc_native2errno(rc);
    }

    __libc_back_fsMutexRelease();
    LIBCLOG_RETURN_INT(rc);
}

