
/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <stdlib.h>
#include <errno.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MISC
#include <InnoTekLIBC/logstrict.h>


/**
 * Creates a directory.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   path    Path to the new directory.
 * @param   mode    Permissions.
 */
int _STD(mkdir)(const char *path, mode_t mode)
{
    LIBCLOG_ENTER("path=%p:{%s} mode=o%o\n", (void *)path, path, mode);
    int rc = __libc_Back_fsDirCreate(path, mode);
    if (!rc)
        LIBCLOG_RETURN_INT(0);
    errno = -rc;
    LIBCLOG_RETURN_INT(-1);
}

