/* $Id: isxxx.c 1519 2004-09-27 02:15:07Z bird $ */
/** @file
 *
 * ctype functions.
 *
 * Usually these routines are not needed (they are inline), but
 * for cases when a program instead of including ctype.h blindly
 * declares them with "extern", they will be linked in.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Copyright (c) 2003-2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#define _DONT_USE_CTYPE_INLINE_
#include "libc-alias.h"
#include <ctype.h>

#undef isalnum
int isalnum(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__UPPER|__LOWER|__DIGIT); }

#undef isalpha
int isalpha(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__UPPER|__LOWER); }

#undef iscntrl
int iscntrl(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__CNTRL); }

#undef isdigit
int isdigit(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__DIGIT); }

#undef isgraph
int isgraph(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__PUNCT|__UPPER|__LOWER|__DIGIT); }

#undef islower
int islower(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__LOWER); }

#undef isprint
int isprint(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__PRINT); }

#undef ispunct
int ispunct(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__PUNCT); }

#undef isspace
int isspace(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__SPACE); }

#undef isupper
int isupper(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__UPPER); }

#undef isxdigit
int isxdigit(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__XDIGIT); }

#undef isblank
int isblank(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__BLANK); }

#undef ishexnumber
int ishexnumber(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__XDIGIT); }

#undef isnumber
int isnumber(int _c)
{ return __libc_GLocaleCtype.ausfType[_c & 0xff] & (__DIGIT); }

#undef toascii
int toascii(int _c)
{ return _c & 0x7f; }

#undef isascii
int isascii(int _c)
{ return (_c & 0x80) != 0; }

