/* $Id: fs.h 1518 2004-09-24 06:11:05Z bird $ */
/** @file
 *
 * LIBC SYS Backend - file system stuff.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird@innotek.de>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __fs_h__
#define __fs_h__

#include <sys/cdefs.h>
#include <sys/syslimits.h>
#include <sys/types.h>


__BEGIN_DECLS

/** Indicator whether or not we're in the unix tree. */
extern int  __libc_gfInUnixTree;
/** Length of the unix root if the unix root is official. */
extern int  __libc_gcchUnixRoot;
/** The current unix root. */
extern char __libc_gszUnixRoot[PATH_MAX];


/**
 * Request the owner ship of the FS mutex.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 */
int __libc_back_fsMutexRequest(void);

/**
 * Releases the owner ship of the FS mutex obtained by __libc_back_fsMutexRelease().
 */
void __libc_back_fsMutexRelease(void);

/**
 * Updates the global unix root stuff.
 * Assumes caller have locked the fs stuff.
 *
 * @param   pszUnixRoot     The new unix root. Fully resolved and existing.
 */
void __libc_back_fsUpdateUnixRoot(const char *pszUnixRoot);

/**
 * Resolves and verifies the user path to a native path.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   pszUserPath     The user path.
 * @param   pszNativePath   Where to store the native path.
 * @param   cchNativePath   Size of the buffer for the native path.
 * @param   fVerify         Whether or not to verify that the path exists.
 * @param   pfDrvSpec       Where to store the drive spec indicator. Optional.
 *                          *pfDrvSpec will be set if the pszUserPath or any symbolic link
 *                          contained pszUserPath referenced contained a drive letter specifier.
 */
int __libc_back_fsResolve(const char *pszUserPath, int fVerify, char *pszNativePath, size_t cchNativePath, int *pfDrvSpec);

/**
 * Creates a symlink.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   pszTarget       The symlink target.
 * @param   pszSymlink      The symlink, the one to be updated.
 */
int __libc_Back_fsSymlinkCreate(const char *pszTarget, const char *pszSymlink);

/**
 * Reads a symbolic link.
 *
 * @returns 0 on success.
 * @returns -1 and errno on failure.
 * @param   pszPath     The symlink to read.
 * @param   pszBuf      Where to read to.
 * @param   cchBuf      Size of the buffer.
 */
int __libc_Back_fsSymlinkRead(const char *pszPath, char *pszBuf, size_t cchBuf);



__END_DECLS

#endif
