/* $Id: largefileio.c 1517 2004-09-19 15:53:31Z bird $ */
/** @file
 *
 * Large File Support.
 *
 * Copyright (c) 2003 Dimitry Froloff
 * Copyright (c) 2003 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with This program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define ORD_DOS32OPENL              981
#define ORD_DOS32SETFILEPTRL        988
#define ORD_DOS32SETFILESIZEL       989
#define ORD_DOS32SETFILELOCKSL      986

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#define INCL_BASE
#include <os2.h>
#include "syscalls.h"


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
ULONG (* _System __pfnDosOpenL)(PCSZ pszFileName, PHFILE phFile,
    PULONG pulAction, LONGLONG llFileSize, ULONG ulAttribute, ULONG ulOpenFlags,
    ULONG ulOpenMode, PEAOP2 pEABuf) = NULL;
ULONG (* _System __pfnDosSetFilePtrL)(HFILE hFile, LONGLONG llOffset,
    ULONG ulOrigin, PLONGLONG pllPos) = NULL;
ULONG (* _System __pfnDosSetFileSizeL)(HFILE hFile, LONGLONG cbSize) = NULL;
ULONG (* _System __pfnDosSetFileLocksL)(HFILE hFile,
    __const__ FILELOCKL *pflUnlock, __const__ FILELOCKL *pflLock,
    ULONG ulTimeout, ULONG flFlags) = NULL;


/**
 * Initiates the function pointers to the large file APIs.
 *
 * I/O functions should test if the function pointer is NULL to determin
 * support for large files.
 *
 * @author  Dimitry Froloff
 * @author  knut st. osmundsen <bird-srcspam@anduin.net>
 */
void _sys_init_largefileio(void)
{
    HMODULE     hmod = NULLHANDLE;

    /* only once! */
    if (__pfnDosOpenL)
        return;

    /*
     * Get a handle to DOSCALLS/DOSCALL1 which is suitable for DosQueryProcAddr.
     */
    if (DosLoadModule(NULL, 0, (PCSZ)"DOSCALLS", &hmod))
    {
        /* this is impossible! */
#ifdef DEBUG
        asm ("int $3");
#endif
        return;
    }

    if (    DosQueryProcAddr(hmod, ORD_DOS32OPENL, NULL, (PFN*)(void *)&__pfnDosOpenL)
        ||  DosQueryProcAddr(hmod, ORD_DOS32SETFILEPTRL, NULL, (PFN*)(void *)&__pfnDosSetFilePtrL)
        ||  DosQueryProcAddr(hmod, ORD_DOS32SETFILESIZEL, NULL, (PFN*)(void *)&__pfnDosSetFileSizeL)
        ||  DosQueryProcAddr(hmod, ORD_DOS32SETFILELOCKSL, NULL, (PFN*)(void *)&__pfnDosSetFileLocksL)
          )
    {
        __pfnDosOpenL = NULL;
        __pfnDosSetFilePtrL = NULL;
        __pfnDosSetFileSizeL = NULL;
        __pfnDosSetFileLocksL = NULL;
    }
    DosFreeModule(hmod);
}

