/* sys/utimes.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <emx/syscalls.h>
#include "syscalls.h"
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_BACK_IO
#include <InnoTekLIBC/logstrict.h>
#include <InnoTekLIBC/pathrewrite.h>


static void _sys_t2p(time_t sec, PFTIME time, PFDATE date)
{
    struct tm *p;
    USHORT tmp;

    p = gmtime(&sec);
#if 0                           /* This didn't work in GCC versions <= 2.4 */
    time->twosecs   = p->tm_sec / 2;
    time->minutes   = p->tm_min;
    time->hours     = p->tm_hour;
    date->day       = p->tm_mday;
    date->month     = p->tm_mon + 1;
    date->year      = p->tm_year - 1980 + 1900;
#else
    tmp = (p->tm_sec / 2) + (p->tm_min << 5) + (p->tm_hour << 11);
    *(USHORT *)time = tmp;
    tmp = p->tm_mday + ((p->tm_mon + 1) << 5) + ((p->tm_year - 80) << 9);
    *(USHORT *)date = tmp;
#endif
}


int __utimes(const char *pszPath, const struct timeval *tvp)
{
    LIBCLOG_ENTER("pszPath=%s tvp=%p {{%ld,%ld}, {%ld,%ld}}\n", pszPath, (void*)tvp,
                  tvp ? tvp[0].tv_sec : ~0, tvp ? tvp[0].tv_usec : ~0,
                  tvp ? tvp[1].tv_sec : ~0, tvp ? tvp[1].tv_usec : ~0);
    int         cch;
    ULONG       rc;
    FILESTATUS3 info;
    FS_VAR();

    /*
     * Rewrite the specified file path.
     */
    cch = __libc_PathRewrite(pszPath, NULL, 0);
    if (cch > 0)
    {
        char *pszRewritten = alloca(cch);
        if (!pszRewritten)
        {
            errno = ENOMEM;
            LIBCLOG_RETURN_INT(-1);
        }
        cch = __libc_PathRewrite(pszPath, pszRewritten, cch);
        if (cch > 0)
            pszPath = pszRewritten;
        /* else happens when someone changes the rules between the two calls. */
        else if (cch < 0)
        {
            errno = EAGAIN;             /* non-standard, I'm sure. */
            LIBCLOG_RETURN_INT(-1);
        }
    }

    /*
     * Validate input.
     */
    if (    (pszPath[0] == '/' || pszPath[0] == '\\')
        &&  (pszPath[1] == 'p' || pszPath[1] == 'P')
        &&  (pszPath[2] == 'i' || pszPath[2] == 'I')
        &&  (pszPath[3] == 'p' || pszPath[3] == 'P')
        &&  (pszPath[4] == 'e' || pszPath[4] == 'E')
        &&  (pszPath[5] == '/' || pszPath[5] == '\\'))
    {
        errno = ENOENT;
        return -1;
    }

    /*
     * Query current path info.
     */
    FS_SAVE_LOAD();
    rc = DosQueryPathInfo((PCSZ)pszPath, FIL_STANDARD, &info, sizeof(info));
    if (rc)
    {
        FS_RESTORE();
        _sys_set_errno(rc);
        LIBCLOG_RETURN_INT(-1);
    }

    /*
     * Apply the new times and update.
     */
    _sys_t2p(tvp[0].tv_sec, &info.ftimeLastAccess, &info.fdateLastAccess);
    _sys_t2p(tvp[1].tv_sec, &info.ftimeLastWrite,  &info.fdateLastWrite);
    rc = DosSetPathInfo((PCSZ)pszPath, FIL_STANDARD, &info, sizeof(info), 0);
    FS_RESTORE();
    if (rc)
    {
        _sys_set_errno(rc);
        LIBCLOG_RETURN_INT(-1);
    }
    LIBCLOG_RETURN_INT(0);
}
