/* beginth.c (emx+gcc) -- Copyright (c) 1992-1998 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSEXCEPTIONS
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/thread.h>
#include <InnoTekLIBC/backend.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_THREAD
#include <InnoTekLIBC/logstrict.h>

/**
 * Thread wrapper routine.
 *
 * @param   pThrd   Pointer to thread structure allocated for this thread.
 */
static void _System threadWrapper(__LIBC_PTHREAD pThrd)
{
    LIBCLOG_ENTER("pThrd=%p\n", pThrd);
    int                         tid;
    EXCEPTIONREGISTRATIONRECORD reg;
    FS_VAR();

    __libc_Back_threadStartup(&reg);
    LIBCLOG_MSG("calling thread function %p with arg %p\n", pThrd->u.startup.pfnStart, pThrd->u.startup.pvArg);
    pThrd->u.startup.pfnStart(pThrd->u.startup.pvArg);
    LIBCLOG_MSG("thread function returned\n");

    __libc_threadTermination(0);
    tid = _gettid();
    __libc_threadFree(pThrd);
    __libc_Back_threadEnd(&reg);
    FS_SAVE_LOAD();
    LIBCLOG_MSG("calling DosExit(%s, 0)\n", tid == 1 ? "EXIT_PROCESS" : "EXIT_THREAD");
    for (;;)
        DosExit(tid == 1 ? EXIT_PROCESS : EXIT_THREAD, 0);
}


int _beginthread(void (*pfnStart)(void *), void *pvStack, unsigned cbStack, void *pvArg)
{
    LIBCLOG_ENTER("pfnStart=%p pvStart=%p cbStack=%d pvArg=%p\n", pfnStart, pvStack, cbStack, pvArg);
    int             rc;
    TID             tid;
    __LIBC_PTHREAD  pThrd;
    FS_VAR();

    /*
     * Allocate a thread structure.
     */
    pThrd = __libc_threadAlloc();
    if (!pThrd)
    {
        errno = ENOMEM;
        LIBCLOG_RETURN_INT(-1);
    }

    /*
     * Set the startup thread info and create a new thread.
     */
    pThrd->u.startup.pfnStart = pfnStart;
    pThrd->u.startup.pvArg    = pvArg;
    FS_SAVE_LOAD();
    rc = DosCreateThread(&tid,
                         (PFNTHREAD)threadWrapper,
                         (ULONG)pThrd,
                         CREATE_READY | STACK_COMMITTED,
                         cbStack);
    FS_RESTORE();
    if (!rc)
        LIBCLOG_RETURN_INT((int)tid);

    /*
     * Set errno and cleanup.
     */
    LIBC_ASSERTM_FAILED("DosCreateThread failed with rc=%u cbStack=%u\n", rc, cbStack);
    if (rc == ERROR_NOT_ENOUGH_MEMORY)
        errno = ENOMEM;
    else if (rc == ERROR_MAX_THRDS_REACHED)
        errno = EAGAIN;
    else
        errno = EINVAL;
    __libc_threadFree(pThrd);
    LIBCLOG_RETURN_INT(-1);
}


void _endthread(void)
{
    LIBCLOG_ENTER("\n");
    __LIBC_PTHREAD  pThrd = __libc_threadCurrent();
    int             tid;
    FS_VAR();

    __libc_threadTermination(0);
    tid = _gettid();
    __libc_threadFree(pThrd);
    FS_SAVE_LOAD();
    LIBCLOG_MSG("calling DosExit(%s, 0)\n", tid == 1 ? "EXIT_PROCESS" : "EXIT_THREAD");
    for (;;)
        DosExit(tid == 1 ? EXIT_PROCESS : EXIT_THREAD, 0);
}
