/* spawnvpe.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <errno.h>

int _STD(spawnvpe) (int mode, const char *name, char * const argv[],
  char * const envp[])
{
  char exe[512];
  char path[512];

  if (strlen (name) >= sizeof (exe) - 4)
    {
      errno = ENAMETOOLONG;
      return -1;
    }
  strcpy (exe, name);
  _defext (exe, "exe");
  if (_path (path, exe) != 0)
    return -1;
  return spawnve (mode, path, argv, envp);
}
