/* getwd.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>

char *_STD(getwd) (char *buffer)
{
  if (buffer == NULL)
    {
      errno = EINVAL;
      return NULL;
    }
  if (__getcwd (buffer+1, 0) < 0)
    {
      _strncpy (buffer, strerror (errno), MAXPATHLEN);
      return NULL;
    }
  _fnslashify (buffer+1);
  buffer[0] = '/';
  return buffer;
}
