/* getcwd.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>

char *_STD(getcwd) (char *buffer, size_t size)
{
  char tmp[MAXPATHLEN+1];
  size_t len;

  if (buffer != NULL && size == 0)
    {
      errno = EINVAL;
      return NULL;
    }
  if (__getcwd (tmp, 0) < 0)
    return NULL;
  len = strlen (tmp) + 2;
  if (buffer != NULL)
    {
      if (len > size)
        {
          errno = ERANGE;
          return NULL;
        }
    }
  else
    {
      if (len > size)
        size = len;
      buffer = malloc (size);
      if (buffer == NULL)
        {
          errno = ENOMEM;
          return NULL;
        }
    }
  _fnslashify (tmp);
  buffer[0] = '/';
  strcpy (buffer+1, tmp);
  return buffer;
}
