/* chdir.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <emx/io.h>
#include <emx/syscalls.h>

int _STD(chdir) (const char *name)
{
  size_t len;
  char *tmp;

  len = strlen (name);
  if (_trslash (name, len, 1))
    {
      tmp = alloca (len);
      memcpy (tmp, name, len - 1);
      tmp[len-1] = 0;
      name = tmp;
    }
  return __chdir (name);
}
