/* sys/syscalls.h (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   sys/filefind.c (libc)    -- Copyright (c) 2003 by Andrew Zabolotny
   sys/filefind.c (libc)    -- Copyright (c) 2003 by Knut St. Osmundsen
 */

#include "libc-alias.h"
#include <sys/signal.h>
#include <InnoTekLIBC/sharedpm.h>

#ifndef __LIBC_THREAD_DECLARED
#define __LIBC_THREAD_DECLARED
struct __libc_thread;
typedef struct __libc_thread *__LIBC_PTHREAD, **__LIBC_PPTHREAD;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (INIT)
#define EXTERN extern
#define INIT(x)
#endif

#define BEGIN do {
#define END   } while (0)

#if !defined (_OS2EMX_H)
typedef unsigned long ULONG;
#endif

/* This macro is used for accessing FDATE or FTIME values as
   USHORT. */

#define XUSHORT(x) (*(USHORT *)&(x))

/* Maximum number of heap objects (16 = 512 / 32). */

#define MAX_HEAP_OBJS   16

/* This structure describes one heap object. */

struct heap_obj
{
  ULONG base;                   /* Base address */
  ULONG end;                    /* End address */
  ULONG brk;                    /* Address of first unused byte */
};

EXTERN int _sys_umask INIT (0022);
EXTERN unsigned _sys_uflags INIT (0);
EXTERN unsigned long _sys_clock0_ms INIT (0);
EXTERN long _sys_ino INIT (0x100000);
EXTERN int _sys_pid;
EXTERN int _sys_ppid;

/** Virtual address limit and high memory indicator.
 *
 * Zero means limit is 512MB.
 * Non zero means more that 512MB. The value is then the size of then the user
 * address space size in bytes.
 *
 * Initiated by __init_dll().
 */
EXTERN unsigned long    _sys_gcbVirtualAddressLimit;

/* The top heap object.  This points into _sys_heap_objs[] or is NULL.
   While this variable is NULL, no memory has been allocated. */

EXTERN struct heap_obj *_sys_top_heap_obj;

/* This array holds information on all the heap objects.  The heap
   objects are managed in LIFO fashion. */

EXTERN struct heap_obj  _sys_heap_objs[MAX_HEAP_OBJS];

/* This is the number of heap objects. */

EXTERN unsigned         _sys_heap_obj_count;

/* This variable can be initialized by the application to control the
   size of the heap object(s). */

extern unsigned         _sys_heap_size;


#if defined (_OS2EMX_H)

/** @group Large File Support - API pointers.
 * Test if the function pointer is set before calling it.
 * For APIs which take a structure level parameter, check __pfnDosOpenL.
 * @{ */
extern ULONG (* _System __pfnDosOpenL)(PCSZ pszFileName, PHFILE phFile,
    PULONG pulAction, LONGLONG llFileSize, ULONG ulAttribute, ULONG ulOpenFlags,
    ULONG ulOpenMode, PEAOP2 pEABuf);
extern ULONG (* _System __pfnDosSetFilePtrL)(HFILE hFile, LONGLONG llOffset,
    ULONG ulOrigin, PLONGLONG pllPos);
extern ULONG (* _System __pfnDosSetFileSizeL)(HFILE hFile, LONGLONG cbSize);
extern ULONG (* _System __pfnDosSetFileLocksL)(HFILE hFile,
    __const__ FILELOCKL *pflUnlock, __const__ FILELOCKL *pflLock,
    ULONG ulTimeout, ULONG flFlags);
/** @} */


/** Test if a DOS/OS2 file time is zero. */
#define FTIMEZEROP(x) (*(PUSHORT)&(x) == 0)
/** Test if a DOS/OS2 file date is zero. */
#define FDATEZEROP(x) (*(PUSHORT)&(x) == 0)

#if defined (INCL_DOSEXCEPTIONS)
EXTERN PEXCEPTIONREGISTRATIONRECORD _sys_xreg INIT (NULL);
ULONG _System _sys_exception (PEXCEPTIONREPORTRECORD report,
    PEXCEPTIONREGISTRATIONRECORD registration, PCONTEXTRECORD context,
    PVOID whatever);
#endif /* defined (INCL_DOSEXCEPTIONS) */

/* TODO: SIGSTOP */
#define SET_BLOCKED(tp,set) ((tp)->sig_blocked = (set) & ~_SIGMASK (SIGKILL))

enum sig_type
{
  ST_TERM,                      /* Terminate process (SIGINT for instance) */
  ST_NEXT,                      /* Pass on to next exception handler */
  ST_IGNORE                     /* Ignore exception and continue thread */
};

struct sig_descr
{
  const char *name;             /* Name of the signal */
  enum sig_type dfl_action;     /* Default action */
  enum sig_type fun_action;     /* Action taken after calling handler */
};

extern char const _sys_sig_valid[NSIG];
extern struct sig_descr const sig_info[NSIG];

long _sys_p2t(FTIME t, FDATE d);
void _sys_deliver_pending_signals(__LIBC_PTHREAD pThrd);

#endif /* _OS2EMX_H */

void _sys_get_clock (unsigned long *ms);

/** @group Heap stuff.
 * @{ */
ULONG _sys_expand_heap_obj_by (ULONG incr);
ULONG _sys_expand_heap_by (ULONG incr, ULONG sbrk_model);
ULONG _sys_shrink_heap_to (ULONG new_brk);
ULONG _sys_shrink_heap_by (ULONG decr, ULONG sbrk_model);
ULONG _sys_shrink_heap_obj_by (ULONG decr);
#ifdef _SYS_FMUTEX_H
/** This mutex semaphore protects the heap. */
EXTERN _fmutex          _sys_heap_fmutex;
/** Mutex semaphore protecting the list of high memory big blocks. */
EXTERN _fmutex          _sys_gmtxHimem;
#endif
/** @} */


/** @group Init Functions
 * @{ */
extern void             __init(int fFlags);
extern int              __init_dll(int fFlags);
extern void /*volatile*/_sys_init_ret(void *stack) __attribute__((__noreturn__));
extern int              _sys_init_environ(const char *pszEnv);
extern void             _sys_init_largefileio(void);
extern int              __libc_fhInit(void);
/** @} */

/** @defgroup grp_sys_inherit   Inherit Function
 * @{ */
__LIBC_PSPMINHFHBHDR    __libc_fhInheritPack(size_t *pcb);
void                    __libc_fhInheritDone(void);
/** @} */

/** @group Term Functions
 * @{ */
extern int              _sys_term_filehandles(void);
/** @} */


/** @group Error code and errno Functions.
 * @{ */
extern void             _sys_set_errno(unsigned long rc);
extern int              __libc_native2errno(unsigned long rc);
/** @} */

/** @group Exec, Spawn and Fork stuff.
 * @{ */
#ifdef _SYS_FMUTEX_H
EXTERN _fmutex          __libc_gmtxExec INIT({0});
#endif
/** @} */

