/* getcwd2.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/libc.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MISC
#include <InnoTekLIBC/logstrict.h>

char *_getcwd2 (char *buffer, int size)
{
    LIBCLOG_ENTER("buffer=%p size=%d\n", (void *)buffer, size);
    char tmp[MAXPATHLEN+1];
    int len;

    if (buffer != NULL && size <= 0)
    {
        errno = EINVAL;
        LIBCLOG_RETURN_P(NULL);
    }
    if (__getcwd (tmp, 0) < 0)
        return NULL;
    len = strlen (tmp) + 4;
    if (buffer != NULL)
    {
        if (len > size)
        {
            errno = ERANGE;
            LIBCLOG_RETURN_P(NULL);
        }
    }
    else
    {
        if (len > size)
            size = len;
        buffer = malloc(size);
        if (buffer == NULL)
        {
            errno = ENOMEM;
            LIBCLOG_RETURN_P(NULL);
        }
    }
    if (!__libc_gfNoUnix)
    {
        _fnslashify(tmp);
        buffer[0] = _getdrive();
        buffer[1] = ':';
        buffer[2] = '/';
        memcpy(buffer+3, tmp, len - 3);
    }
    else
    {
        buffer[0] = _getdrive();
        buffer[1] = ':';
        buffer[2] = '\\';
        memcpy(buffer+3, tmp, len - 3);
    }
    LIBCLOG_RETURN_MSG(buffer, "ret %p:{%s}\n", (void *)buffer, buffer);
}
