/* getcwd.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/libc.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MISC
#include <InnoTekLIBC/logstrict.h>

char *_STD(getcwd)(char *buffer, size_t size)
{
    LIBCLOG_ENTER("buffer=%p size=%d\n", buffer, size);
    if (!__libc_gfNoUnix)
    {
        char tmp[MAXPATHLEN+1];
        size_t len;

        if (buffer != NULL && size == 0)
        {
            errno = EINVAL;
            LIBCLOG_RETURN_P(NULL);
        }
        if (__getcwd(tmp, 0) < 0)
            return NULL;
        len = strlen(tmp) + 2;
        if (buffer != NULL)
        {
            if (len > size)
            {
                errno = ERANGE;
                LIBCLOG_RETURN_P(NULL);
            }
        }
        else
        {
            if (len > size)
                size = len;
            buffer = malloc(size);
            if (buffer == NULL)
            {
                errno = ENOMEM;
                LIBCLOG_RETURN_P(NULL);
            }
        }
        _fnslashify(tmp);
        buffer[0] = '/';
        memcpy(buffer + 1, tmp, len - 1);
        LIBCLOG_RETURN_MSG(buffer, "ret %p:{%s}\n", (void *)buffer, buffer);
    }
    else
    {
        char *pszRet = _getcwd2(buffer, size);
        LIBCLOG_RETURN_P(pszRet);
    }
}
