/* $Id: _getdcwd.c 1508 2004-09-15 00:34:25Z bird $ */
/** @file
 *
 * VAC/MSC interface.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of InnoTek LIBC.
 *
 * InnoTek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * InnoTek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with InnoTek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <direct.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/libc.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_MISC
#include <InnoTekLIBC/logstrict.h>


char * _getdcwd(int chDrive, char *pszBuffer, int cchBuffer)
{
    LIBCLOG_ENTER("chDrive=%d pszBuffer=%p cchBuffer=%d\n", chDrive, (void *)pszBuffer, cchBuffer);
    char szTmp[MAXPATHLEN+1];
    int len;

    if (pszBuffer != NULL && cchBuffer <= 0)
    {
        errno = EINVAL;
        LIBCLOG_RETURN_P(NULL);
    }
    if (__getcwd(szTmp, chDrive + 'A' - 1) < 0)
        return NULL;
    len = strlen(szTmp) + 4;
    if (pszBuffer != NULL)
    {
        if (len > cchBuffer)
        {
            errno = ERANGE;
            LIBCLOG_RETURN_P(NULL);
        }
    }
    else
    {
        if (len > cchBuffer)
            cchBuffer = len;
        pszBuffer = malloc(cchBuffer);
        if (pszBuffer == NULL)
        {
            errno = ENOMEM;
            LIBCLOG_RETURN_P(NULL);
        }
    }
    if (!__libc_gfNoUnix)
    {
        _fnslashify(szTmp);
        pszBuffer[0] = chDrive ? chDrive + 'A' - 1: _getdrive();
        pszBuffer[1] = ':';
        pszBuffer[2] = '/';
        memcpy(pszBuffer+3, szTmp, len - 3);
    }
    else
    {
        pszBuffer[0] = chDrive ? chDrive + 'A' - 1: _getdrive();
        pszBuffer[1] = ':';
        pszBuffer[2] = '\\';
        memcpy(pszBuffer+3, szTmp, len - 3);
    }
    LIBCLOG_RETURN_MSG(pszBuffer, "ret %p:{%s}\n", (void *)pszBuffer, pszBuffer);
}

