/* grp.h (emx+gcc) */

#ifndef _GRP_H_
#define _GRP_H_
#define _GRP_H

#include <sys/cdefs.h>
#include <sys/_types.h>

__BEGIN_DECLS

#ifndef _POSIX_SOURCE
#define	_PATH_GROUP		"/etc/group"
#endif

#if !defined(_GID_T_DECLARED) && !defined(_GID_T)
typedef	__gid_t gid_t;
#define	_GID_T_DECLARED
#define	_GID_T
#endif

#if !defined(_SIZE_T_DECLARED) && !defined(_SIZE_T)
typedef __size_t size_t;
#define _SIZE_T_DECLARED
#define _SIZE_T
#endif


struct group
{
  char *gr_name;
  char *gr_passwd;
  gid_t gr_gid;
  char **gr_mem;
};

struct group   *getgrgid (gid_t);
struct group   *getgrnam (const char *);

#if __BSD_VISIBLE || __POSIX_VISIBLE >= 200112 || __XSI_VISIBLE
struct group   *getgrent(void);
int             setgrent(void);
void            endgrent(void);
void            setgrfile(const char *);
int             setgroupent(int);
int             getgrgid_r(gid_t, struct group *, char *, size_t, struct group **);
int             getgrnam_r(const char *, struct group *, char *, size_t, struct group **);
#endif

#if __BSD_VISIBLE
const char     *group_from_gid(gid_t, int);
int             getgrent_r(struct group *, char *, size_t, struct group **);
int             setgroupent(int);
#endif

__END_DECLS

#endif /* not _GRP_H_ */
