/*-
 * Copyright (c) 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)unistd.h	8.12 (Berkeley) 4/27/95
 * $FreeBSD: src/include/unistd.h,v 1.66 2002/12/29 01:07:55 mike Exp $
 */

/** @file
 * EMX/FreeBSD 5.1
 *
 * @changed Commented out stuff which isn't implemented, TCPIP stuff at bottom.
 * @todo    Several man-years.. ;) Serious, complete the FreeBSD 5.1 merge and
 *          implement all the functions. Currently there is a bunch of POSIX
 *          #defines missing.
 */

#ifndef _UNISTD_H_
#define _UNISTD_H_
#define _UNISTD_H                       /* bird: emx */


#include <sys/cdefs.h>
#include <sys/types.h>			/* XXX adds too much pollution. */
/** @todo port FreeBSD sys/unistd.h: #include <sys/unistd.h> */
#include <sys/_types.h>

#if !defined(_GID_T_DECLARED) && !defined(_GID_T) /* bird: emx */
typedef	__gid_t		gid_t;		/* group id */
#define	_GID_T_DECLARED
#define _GID_T                          /* bird: emx */
#endif

#if !defined(_OFF_T_DECLARED) && !defined(_OFF_T) /* bird:emx */
typedef	__off_t		off_t;		/* file offset */
#define	_OFF_T_DECLARED
#define _OFF_T                          /* bird: emx */
#endif

#if !defined(_PID_T_DECLARED) && !defined(_PID_T) /* bird:emx */
typedef	__pid_t		pid_t;		/* process id */
#define	_PID_T_DECLARED
#define _PID_T                          /* bird: emx */
#endif

#if !defined(_SIZE_T_DECLARED) && !defined(_SIZE_T) /* bird: emx */
typedef	__size_t	size_t;
#define	_SIZE_T_DECLARED
#define _SIZE_T                         /* bird: emx */
#endif

#if !defined(_SSIZE_T_DECLARED) && !defined(_SSIZE_T) /* bird: emx */
typedef	__ssize_t	ssize_t;
#define	_SSIZE_T_DECLARED
#define _SSIZE_T                        /* bird: emx */
#endif

#if !defined(_UID_T_DECLARED) && !defined(_UID_T)  /* bird: emx */
typedef	__uid_t		uid_t;		/* user id */
#define	_UID_T_DECLARED
#define _UID_T                          /* bird: emx */
#endif

#ifndef _USECONDS_T_DECLARED
typedef	__useconds_t	useconds_t;	/* microseconds (unsigned) */
#define	_USECONDS_T_DECLARED
#endif

#if !defined(STDIN_FILENO)              /* bird: emx */
#define	 STDIN_FILENO	0	/* standard input file descriptor */
#define	STDOUT_FILENO	1	/* standard output file descriptor */
#define	STDERR_FILENO	2	/* standard error file descriptor */
#endif

#ifndef NULL
#define	NULL		0	/* null pointer constant */
#endif

#if __XSI_VISIBLE || __POSIX_VISIBLE >= 200112
#define	F_ULOCK		0	/* unlock locked section */
#define	F_LOCK		1	/* lock a section for exclusive use */
#define	F_TLOCK		2	/* test and lock a section for exclusive use */
#define	F_TEST		3	/* test a section for locks by other procs */
#endif


/** @todo: big todo to get in all the POSIX defines. */

/* whence values for lseek(2) */
#ifndef SEEK_SET
#define	SEEK_SET	0	/* set file offset to offset */
#define	SEEK_CUR	1	/* set file offset to current plus offset */
#define	SEEK_END	2	/* set file offset to EOF plus offset */
#endif

#ifndef _POSIX_SOURCE
/* whence values for lseek(2); renamed by POSIX 1003.1 */
#define	L_SET		SEEK_SET
#define	L_INCR		SEEK_CUR
#define	L_XTND		SEEK_END
#endif

#if !defined (F_OK)
#define F_OK 0
#define X_OK 1
#define W_OK 2
#define R_OK 4
#endif

#if !defined (SEEK_SET)
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#if !defined (_PC_LINK_MAX)
#define _PC_LINK_MAX            1
#define _PC_MAX_CANON           2
#define _PC_MAX_INPUT           3
#define _PC_NAME_MAX            4
#define _PC_PATH_MAX            5
#define _PC_PIPE_BUF            6
#define _PC_CHOWN_RESTRICTED    7
#define _PC_NO_TRUNC            8
#define _PC_VDISABLE            9
#endif

#if !defined (_SC_ARG_MAX)
#define _SC_ARG_MAX             1
#define _SC_CHILD_MAX           2
#define _SC_CLK_TCK             3
#define _SC_NGROUPS_MAX         4
#define _SC_OPEN_MAX            5
#define _SC_STREAM_MAX          6
#define _SC_TZNAME_MAX          7
#define _SC_JOB_CONTROL         8
#define _SC_SAVED_IDS           9
#define _SC_VERSION             10
#endif

#if !defined (_POSIX_VERSION)
#define _POSIX_VERSION          199009L
#endif


__BEGIN_DECLS
/* 1003.1-1990 */
void     _exit(int) __dead2;
int      access(const char *, int);
unsigned int     alarm(unsigned int);
int      chdir(const char *);
int	 chown(const char *, uid_t, gid_t);
int      close(int);
char *   cuserid(char *); /* bird: emx/todo/obosolete? */
int      dup(int);
int      dup2(int, int);
int	 eaccess(const char *, int);
int      execl(const char *, const char *, ...);
int      execle(const char *, const char *, ...);
int      execlp(const char *, const char *, ...);
int      execv(const char *, char * const *);
int      execve(const char *, char * const *, char * const *);
int      execvp(const char *, char * const *);
pid_t    fork(void);
long     fpathconf(int, int);
char    *getcwd(char *, size_t);
gid_t    getegid(void);
uid_t    geteuid(void);
gid_t    getgid(void);
int      getgroups(int, gid_t []);
char    *getlogin(void);
pid_t    getpgrp(void);
pid_t    getpid(void);
pid_t    getppid(void);
uid_t    getuid(void);
int      isatty(int);
int	 link(const char *, const char *);
#ifndef _LSEEK_DECLARED
#define	_LSEEK_DECLARED
off_t    lseek(int, off_t, int);
#endif
long     pathconf(const char *, int);
int      pause(void);
int      pipe(int *);
ssize_t  read(int, void *, size_t);
int      rmdir(const char *);
int      setgid(gid_t);
/** @todo void	 setproctitle(const char *_fmt, ...) __printf0like(1, 2); */
int      setpgid(pid_t, pid_t);
pid_t    setsid(void);
int      setuid(uid_t);
unsigned sleep(unsigned);
long     sysconf(int);
pid_t    tcgetpgrp(int);
int      tcsetpgrp(int, pid_t);
char    *ttyname(int);
int      unlink(const char *);
int      write(int, const void *, size_t);

/* 1003.2-1992 */
#if __POSIX_VISIBLE >= 199209 || __XSI_VISIBLE
/** @todo size_t	 confstr(int, char *, size_t);*/
int	 getopt(int, char * const [], const char *);

extern char *optarg;			/* getopt(3) external variables */
extern int optind, opterr, optopt;
#endif

/* ISO/IEC 9945-1: 1996 */
#if __POSIX_VISIBLE >= 199506 || __XSI_VISIBLE
int	 fsync(int);

/*
 * ftruncate() was in the POSIX Realtime Extension (it's used for shared
 * memory), but truncate() was not.
 */
#ifndef _FTRUNCATE_DECLARED
#define	_FTRUNCATE_DECLARED
int	 ftruncate(int, off_t);
#endif
#endif

#if __POSIX_VISIBLE >= 199506
/** @todo int	 getlogin_r(char *, int); */
#endif

/* 1003.1-2001 */
#if __POSIX_VISIBLE >= 200112 || __XSI_VISIBLE
int	 fchown(int, uid_t, gid_t);
int	 readlink(const char *, char *, int);
#endif
#if __POSIX_VISIBLE >= 200112
/* tcpip: int	 gethostname(char *, int / * socklen_t * /); */
/** @todo int	 setegid(gid_t);  */
/** @todo int	 seteuid(uid_t); */
#endif

/*
 * symlink() was originally in POSIX.1a, which was withdrawn after
 * being overtaken by events (1003.1-2001).  It was in XPG4.2, and of
 * course has been in BSD since 4.2.
 */
#if __POSIX_VISIBLE >= 200112 || __XSI_VISIBLE >= 402 || __BSD_VISIBLE
int	 symlink(const char * __restrict, const char * __restrict);
#endif

/* X/Open System Interfaces */
#if __XSI_VISIBLE
/** @todo char	*crypt(const char *, const char *); */
/** @todo char	*ctermid(char *); */		/* XXX ??? */
/** @todo int	 encrypt(char *, int); */
/** @todo int	 fchdir(int); */
/* tcpip: long	 gethostid(void); */
/** @todo int	 getpgid(pid_t _pid); */
/** @todo int	 getsid(pid_t _pid); */
char	*getwd(char *);			/* LEGACY: obsoleted by getcwd() */
int	 lchown(const char *, uid_t, gid_t);
int	 lockf(int, int, off_t);
/** @todo int	 nice(int); */
/** @todo ssize_t	 pread(int, void *, size_t, off_t); */
/** @todo ssize_t	 pwrite(int, const void *, size_t, off_t); */
/** @todo int	 setpgrp(pid_t _pid, pid_t _pgrp); */ /* obsoleted by setpgid() */
/** @todo int	 setregid(gid_t, gid_t); */
/** @todo int	 setreuid(uid_t, uid_t); */
/* void	 swab(const void * __restrict, void * __restrict, ssize_t); */
void	 sync(void);
/** @todo useconds_t	 ualarm(useconds_t, useconds_t); */
int	 usleep(useconds_t);
/** @todo pid_t	 vfork(void); */

/* See comment at ftruncate() above. */
#ifndef _TRUNCATE_DECLARED
#define	_TRUNCATE_DECLARED
int	 truncate(const char *, off_t);
#endif
#endif /* __XSI_VISIBLE */

#if __XSI_VISIBLE <= 500 || __BSD_VISIBLE
int	 brk(const void *);
/** @todo int	 chroot(const char *); */
/** @todo int	 getdtablesize(void); */
int	 getpagesize(void) __pure2;
char	*getpass(const char *);
char    *_getpass1(const char *);          /* bird: emx stuff */
char    *_getpass2(const char *, int);     /* bird: emx stuff */
void	*sbrk(intptr_t);
#endif

#if __BSD_VISIBLE
struct timeval;				/* select(2) */
/** @todo int	 acct(const char *); */
/** @todo int	 async_daemon(void); */
/** @todo int	 check_utility_compat(const char *); */
/** @todo const char *
	 crypt_get_format(void); */
/** @todo int	 crypt_set_format(const char *); */
/** @todo int	 des_cipher(const char *, char *, long, int); */
/** @todo int	 des_setkey(const char *key); */
void	 endusershell(void);
/** @todo int	 exect(const char *, char * const *, char * const *); */
/** @todo char	*fflagstostr(u_long); */
/** @todo int	 getdomainname(char *, int); */
/** @todo int	 getgrouplist(const char *, gid_t, gid_t *, int *); */
/** @todo mode_t	 getmode(const void *, mode_t); */
/** @todo int	 getpeereid(int, uid_t *, gid_t *); */
/** @todo int	 getresgid(gid_t *, gid_t *, gid_t *); */
/** @todo int	 getresuid(uid_t *, uid_t *, uid_t *); */
char	*getusershell(void);
/** @todo int	 initgroups(const char *, gid_t); */
/** @todo int	 iruserok(unsigned long, int, const char *, const char *); */
/** @todo int	 iruserok_sa(const void *, int, int, const char *, const char *); */
/** @todo int	 issetugid(void); */
/** @todo char	*mkdtemp(char *); */
int	 mknod(const char *, mode_t, dev_t);
#ifndef _MKSTEMP_DECLARED
int	 mkstemp(char *);
#define	_MKSTEMP_DECLARED
#endif
/** @todo int	 mkstemps(char *, int); */
#ifndef _MKTEMP_DECLARED
char	*mktemp(char *);
#define	_MKTEMP_DECLARED
#endif
/** @todo int	 nfsclnt(int, void *); */
/** @todo int	 nfssvc(int, void *); */
/** @todo int	 profil(char *, size_t, vm_offset_t, int); */
/** @todo int	 rcmd(char **, int, const char *, const char *, const char *, int *); */
/** @todo int	 rcmd_af(char **, int, const char *,
		const char *, const char *, int *, int); */
/** @todo int	 rcmdsh(char **, int, const char *,
		const char *, const char *, const char *); */
char	*re_comp(const char *);
int	 re_exec(const char *);
/** @todo int	 reboot(int); */
/** @todo int	 revoke(const char *); */
/** @todo pid_t	 rfork(int); */
/** @todo pid_t	 rfork_thread(int, void *, int (*)(void *), void *); */
/** @todo int	 rresvport(int *); */
/** @todo int	 rresvport_af(int *, int); */
/** @todo int	 ruserok(const char *, int, const char *, const char *); */
#if __BSD_VISIBLE
#ifndef _SELECT_DECLARED
#define	_SELECT_DECLARED
int	 select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif
#endif
/** @todo int	 setdomainname(const char *, int); */
int	 setgroups(int, const gid_t *);
/** @todo void	 sethostid(long); */
/** @todo int	 sethostname(const char *, int); */
/** @todo #ifndef _SETKEY_DECLARED */
/** @todo int	 setkey(const char *); */
/** @todo #define	_SETKEY_DECLARED */
/** @todo #endif */
/** @todo int	 setlogin(const char *); */
/* crash with DOS: void	*setmode(const char *); */
/** @todo int	 setresgid(gid_t, gid_t, gid_t); */
/** @todo int	 setresuid(uid_t, uid_t, uid_t); */
/** @todo int	 setrgid(gid_t); */
/** @todo int	 setruid(uid_t); */
void	 setusershell(void);
/** @todo int	 strtofflags(char **, u_long *, u_long *); */
/** @todo int	 swapon(const char *); */
/** @todo int	 swapoff(const char *); */
/** @todo int	 syscall(int, ...); */
/** @todo off_t	 __syscall(quad_t, ...); */
/** @todo int	 ttyslot(void); */
/** @todo int	 undelete(const char *); */
/** @todo int	 unwhiteout(const char *); */
/** @todo void	*valloc(size_t); */			/* obsoleted by malloc() */

/** @todo extern char *suboptarg; */			/* getsubopt(3) external variable */
/** @todo #ifndef _GETSUBOPT_DECLARED */
/** @todo int	 getsubopt(char **, char * const *, char **); */
/** @todo #define	_GETSUBOPT_DECLARED */
/** @todo #endif */
extern int optreset;			/* getopt(3) external variable */
#endif /* __BSD_VISIBLE */


#if !defined(_POSIX_SOURCE)


#endif


#if !defined(_POSIX_SOURCE) || defined(_WITH_UNDERSCORE)
/** @todo update this section to match the one without underscores as far as needed! */
void     __exit(int) __dead2;
int      _access(const char *, int);
unsigned int _alarm(unsigned int);
int      _chdir(const char *);
int	 _chown(const char *, uid_t, gid_t);
int      _close(int);
char    *_cuserid(char *);
int      _dup(int);
int      _dup2(int, int);
int	 _eaccess(const char *, int);
int      _execl(const char *, const char *, ...);
int      _execle(const char *, const char *, ...);
int      _execlp(const char *, const char *, ...);
int      _execv(const char *, char * const *);
int      _execve(const char *, char * const *, char * const *);
int      _execvp(const char *, char * const *);
pid_t    _fork(void);
long     _fpathconf(int, int);
char    *_getcwd(char *, size_t);
gid_t    _getegid(void);
uid_t    _geteuid(void);
gid_t    _getgid(void);
int      _getgroups(int, gid_t []);
char    *_getlogin(void);
pid_t    _getpgrp(void);
pid_t    _getpid(void);
pid_t    _getppid(void);
uid_t    _getuid(void);
int      _isatty(int);
int	 _link(const char *, const char *);
#ifndef __LSEEK_DECLARED
#define	__LSEEK_DECLARED
off_t    _lseek(int, off_t, int);
#endif
long     _pathconf(const char *, int);
int      _pause(void);
int      _pipe(int *);
ssize_t  _read(int, void *, size_t);
int      _rmdir(const char *);
int      _setgid(gid_t);
/** @todo void	 _setproctitle(const char *_fmt, ...) __printf0like(1, 2); */
int      _setpgid(pid_t, pid_t);
pid_t    _setsid(void);
int      _setuid(uid_t);
unsigned _sleep(unsigned);
long     _sysconf(int);
pid_t    _tcgetpgrp(int);
pid_t    _tcsetpgrp(int, int);
char    *_ttyname(int);
int      _unlink(const char *);
int      _write(int, const void *, size_t);

int      _brk(const void *);
char    *_getpass(const char *);
char    *_getpass1(const char *);
char    *_getpass2(const char *, int);
int     _mkstemp(char *);
char    *_mktemp(char *);
void	*_sbrk(intptr_t);
/** @todo int     _profil(void *, unsigned, unsigned, unsigned); */

/* 1003.2-1992 */
extern char *_optarg;
extern int _optind;
extern int _opterr;
extern int _optopt;
int      _getopt(int, char **, const char *);

#endif

/* Toolkit compatibility */
#ifndef TCPCALL
#define TCPCALL _System
#endif

#include <sys/cdefs.h>
#include <sys/types.h>
int     TCPCALL     soclose(int);
#ifndef _POSIX_SOURCE
int     TCPCALL     gethostid(void);
int     TCPCALL     gethostname(char *, int);
#ifndef TCPV40HDRS
int     TCPCALL     iruserok(unsigned long, int, const char *, const char *);
int     TCPCALL     rcmd(char **, int, const char *, const char *, const char *, int *);
int     TCPCALL     rresvport(int *);
int     TCPCALL     ruserok(const char *, int, const char *, const char *);
#include <sys/select.h>
#endif /* !TCP40HDRS */
#endif /* !_POSIX_SOURCE */

__END_DECLS

#endif /* not _UNISTD_H */
