/* sys/spawnve.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <errno.h>
#include <alloca.h>
#include <386/builtin.h>
#include <sys/fmutex.h>
#define INCL_DOSPROCESS
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <InnoTekLIBC/sharedpm.h>
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_PROCESS
#include <InnoTekLIBC/logstrict.h>
#include "syscalls.h"


/**
 * Collects and creates the inherit stuff we send down to a LIBC child.
 * @returns Pointer to inherit structure on success.
 * @returns NULL and errno on failure.
 */
static __LIBC_PSPMINHERIT doInherit(void)
{
    LIBCLOG_ENTER("\n");
    size_t                  cbFH;
    __LIBC_PSPMINHFHBHDR    pFH;
    __LIBC_PSPMINHERIT      pRet = NULL;

    /*
     * Get FH stuff.
     */
    pFH = __libc_fhInheritPack(&cbFH);
    if (pFH)
    {
        /*
         * Allocate shared memory.
         */
        size_t  cb = sizeof(__LIBC_SPMINHERIT) + ((cbFH + 3) & ~3);
        pRet = __libc_spmAlloc(cb);
        if (pRet)
        {
            pRet->cb = sizeof(*pRet);
            pRet->pFHBundles = (__LIBC_PSPMINHFHBHDR)(pRet + 1);
            memcpy(pRet->pFHBundles, pFH, cbFH);
            free(pFH);
            LIBCLOG_RETURN_P(pRet);
        }
        /* cleanup on failure */
        __libc_fhInheritDone();
        free(pFH);
    }

    LIBCLOG_RETURN_P(pRet);
}


/**
 * Cleans up any globale inherit stuff.
 */
static void doInheritDone(void)
{
    __libc_fhInheritDone();
}

/* Note: We are allowed to call _trealloc() as this module is not used
   in an .a library. */

#define ADD(n) do { \
  while (arg_size + n > arg_alloc) \
    { \
      arg_alloc += 512; \
      arg_buf = _trealloc (arg_buf, arg_alloc); \
      if (arg_buf == NULL) \
        { \
          errno = ENOMEM; \
          return -1; \
        } \
      arg_ptr = arg_buf + arg_size; \
    } \
  arg_size += n; } while (0)


int __spawnve (struct _new_proc *np)
{
  LIBCLOG_ENTER("np=%p:{mode=%#x}\n", (void *)np, np->mode);
  int   rc;
  ULONG exec_flag, mode;
  RESULTCODES res;
  char obj[40], *arg_ptr, *arg_buf;
  char *pgm_name, *base;
  const char *src, *s;
  size_t arg_size, arg_alloc, len;
  int i, quote, bs, method;
  __LIBC_PSPMPROCESS    pEmbryo;
  FS_VAR();

  arg_buf = NULL; arg_alloc = 0; arg_size = 0; arg_ptr = NULL;

  mode = np->mode;
  switch (mode & 0xff)
    {
    case P_WAIT:
      exec_flag = EXEC_SYNC;
      break;
    case P_NOWAIT:
      exec_flag = EXEC_ASYNCRESULT;
      break;
    case P_OVERLAY:
      exec_flag = EXEC_ASYNC;
      break;
    default:
      errno = EINVAL;
      LIBCLOG_RETURN_INT(-1);
    }
  pgm_name = alloca (strlen ((const char *)np->fname_off) + 5);
  strcpy (pgm_name, (const char *)np->fname_off);
  _defext (pgm_name, "exe");
  base = _getname (pgm_name);
  method = 0;
  if (stricmp (base, "cmd.exe") == 0 || stricmp (base, "4os2.exe") == 0)
    method = 1;
  src = (const char *)np->arg_off;
  if (np->arg_count > 0)
    {
      ++src;                    /* skip flags byte */
      len = strlen (src) + 1;
      ADD (len);
      memcpy (arg_ptr, src, len);
      arg_ptr += len; src += len;
    }
  for (i = 1; i < np->arg_count; ++i)
    {
      if (i > 1)
        {
          ADD (1);
          *arg_ptr++ = ' ';
        }
      ++src;                    /* skip flags byte */
      quote = FALSE;
      if (*src == 0)
        quote = TRUE;
      else if (mode & P_QUOTE)
        {
          if (src[0] == '@' && src[1] != 0)
            quote = TRUE;
          else
            for (s = src; *s != 0; ++s)
              if (*s == '?' || *s == '*')
                {
                  quote = TRUE;
                  break;
                }
        }
      if (!quote)
        for (s = src; *s != 0; ++s)
          if (*s == ' ' || *s == '\t' || (*s == '"' && method == 1))
            {
              quote = TRUE;
              break;
            }
      if (quote)
        {
          ADD (1);
          *arg_ptr++ = '"';
        }
      bs = 0;
      while (*src != 0)
        {
          if (*src == '"' && method == 0)
            {
              ++bs;
              ADD (bs);
              memset (arg_ptr, '\\', bs); arg_ptr += bs;
              bs = 0;
            }
          else if (*src == '\\' && method == 0)
            ++bs;
          else
            bs = 0;
          ADD (1);
          *arg_ptr++ = *src;
          ++src;
        }
      if (quote)
        {
          ADD (1+bs);
          memset (arg_ptr, '\\', bs); arg_ptr += bs;
          *arg_ptr++ = '"';
        }
      ++src;
    }
  /* The arguments are an array of zero terminated strings, ending with an empty string. */
  ADD (2);
  *arg_ptr++ = '\0';
  *arg_ptr++ = '\0';

  _fmutex_request(&__libc_gmtxExec, 0);

  /*
   * Now create an embryo process.
   */
  pEmbryo = __libc_spmCreateEmbryo(getpid());
  if (pEmbryo)
  {
      /*
       * Do inheritance stuff.
       */
      pEmbryo->pInherit = doInherit();
      if (pEmbryo->pInherit)
      {
          /*
           * Create the process.
           */
          FS_SAVE_LOAD();
          rc = DosExecPgm (obj, sizeof (obj), exec_flag, (PCSZ)arg_buf, (PCSZ)np->env_off, &res, (PCSZ)pgm_name);
          FS_RESTORE();
          if (!rc)
          {
              if (exec_flag == EXEC_ASYNCRESULT || exec_flag == EXEC_ASYNC)
              {
                  __atomic_cmpxchg32((volatile uint32_t *)(void *)&pEmbryo->pid, (uint32_t)res.codeTerminate, 0);
                  LIBCLOG_MSG("Spawned pid=%04lx (%ld)\n", res.codeTerminate, res.codeTerminate);
              }

              /* cleanup embryo and other stuff. */
              __libc_spmRelease(pEmbryo);
              doInheritDone();
              if (arg_buf != NULL)
                  _tfree (arg_buf);
              _fmutex_release(&__libc_gmtxExec);

              /* exit depends on the mode. */
              switch (mode & 0xff)
                {
                case P_WAIT:
                  LIBCLOG_RETURN_INT((int)res.codeResult);
                case P_NOWAIT:
                  LIBCLOG_RETURN_INT((int)res.codeTerminate);
                case P_OVERLAY:
                  FS_SAVE_LOAD();
                #if 1 /* hack... */
                {
                  PID pid = res.codeTerminate;
                  for (;;)
                  {
                      PID   pidEnded = 0;
                      LIBCLOG_MSG("Calling DosWaitChild(,,,,0x%04lx)\n", pid);
                      rc = DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &res, &pidEnded, pid);
                      if (rc)
                      {
                          LIBCLOG_MSG("Calling DosWaitChild(,,,,0x%04lx) -> rc=%d\n", pid, rc);
                          break;
                      }
                      LIBCLOG_MSG("Calling DosWaitChild(,,,,0x%04lx) pidEnded=0x%04lx res.codeTerminate=%ld res.codeResult=%ld\n",
                                  pid, pidEnded, res.codeTerminate, res.codeResult);
                      while (pid == pidEnded)
                          DosExit(EXIT_PROCESS, res.codeResult);
                  }
                }
                #endif
                  LIBCLOG_MSG("Calling DosExit(,0)\n");
                  while (1)
                    DosExit (EXIT_PROCESS, 0);
                default:
                  errno = EINVAL;
                  LIBCLOG_RETURN_INT(-1);
                }
              /* won't ever get here! */
          }
          else
            _sys_set_errno (rc);
          doInheritDone();
      }
      /* cleanup embryo */
      __libc_spmRelease(pEmbryo);
  }

  if (arg_buf != NULL)
    _tfree (arg_buf);
  _fmutex_release(&__libc_gmtxExec);
  LIBCLOG_RETURN_INT(-1);
}
