/* $Id: __initdll.c 1461 2004-09-06 04:22:46Z bird $ */
/** @file

    Dynamic library low-level initialization routine.

    Copyright (c) 1992-1998 by Eberhard Mattes
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    This routine is called from dll0.o. It should perform
    all kinds of low-level initialization required by a DLL.
*/


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#define INCL_DOS
#define INCL_FSMACROS
#include <os2emx.h>
#define _osmajor __osminor
#define _osminor __osminor
#include <stdlib.h>
#undef _osmajor
#undef _osminor
#include <string.h>
#include <errno.h>
#include <sys/builtin.h>
#include <sys/fmutex.h>
#include <emx/startup.h>
#include <emx/syscalls.h>
#include <emx/umalloc.h>
#include <alloca.h>
#include <InnoTekLIBC/fork.h>
#include "syscalls.h"
#include <InnoTekLIBC/thread.h>
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_INITTERM
#include <InnoTekLIBC/logstrict.h>

/* Make this function an weak external. */
#pragma weak __init_largefileio


/*******************************************************************************
*   Structures and Typedefs                                                    *
*******************************************************************************/
/**
 * Argument to initdllForkTLM().
 */
typedef struct TLMARGS_s
{
    /** Pointer to the TLM entry. */
    PULONG          pTLM;
    /** Pointer to the current thread. */
    __LIBC_PTHREAD  pCurThread;
} TLMARGS, *PTLMARGS;


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
__LIBC_PPTHREAD     __libc_gpTLS;

extern unsigned char _osminor;
extern unsigned char _osmajor;


/*******************************************************************************
*   Internal Functions                                                         *
*******************************************************************************/
static int initdllForkParent1(__LIBC_PFORKHANDLE pForkHandle, __LIBC_FORKOP enmOperation);
static int initdllForkChild1(__LIBC_PFORKHANDLE pForkHandle, __LIBC_FORKOP enmOperation);
static int initdllForkTLM(__LIBC_PFORKHANDLE pForkHandle, void *pvArg, size_t cbArg);


/**
 * Common init code for crt0 and dll0.
 * This should perhaps be a part of _CRT_init.
 */
int __init_dll(int fDefaultHeapInHighMem)
{
    ULONG               aul[2];
    int                 rc;
    PTIB                ptib;
    PPIB                ppib;
    __LIBC_PSPMPROCESS  pSelf;

    static int fInitialized = 0;

    /*
     * Heap voting.
     */
    __libc_HeapVote(fDefaultHeapInHighMem);

    /*
     * The rest must only be executed once.
     */
    if (fInitialized)
        return 0;
    fInitialized = 1;

    /*
     * Initialize _osmajor and _osminor.
     */
    DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_MINOR, &aul[0], sizeof(aul));
    _osminor = (unsigned char)aul[1];
    _osmajor = (unsigned char)aul[0];

    /*
     * Check for high memory (>512MB) support.
     */
    _sys_gcbVirtualAddressLimit = 0;
    if (    !DosQuerySysInfo(QSV_VIRTUALADDRESSLIMIT, QSV_VIRTUALADDRESSLIMIT, &aul[0], sizeof(aul[0]))
        &&  aul[0] > 512
        &&  (   (_osmajor == 20 && _osminor >= 40)
             || _osmajor > 20 /* yeah, sure! */) )
        _sys_gcbVirtualAddressLimit = aul[0] * 1024*1024;

    /*
     * Get the process ID and parent process ID.
     * This is also required for (stand-alone) DLLs. At least, we need ptib
     * and ppib.
     */
    /** @todo This must be replaced by the fast info block code from Odin/kLib. */
    rc = DosGetInfoBlocks(&ptib, &ppib);
    if (rc != 0)
        return -1;
    _sys_pid = ppib->pib_ulpid;
    _sys_ppid = ppib->pib_ulppid;

    /*
     * Initialize the heap semaphores.
     */
    if (_fmutex_create(&_sys_heap_fmutex, 0) != 0)
        return -1;
    if (_fmutex_create(&_sys_gmtxHimem, 0) != 0)
        return -1;
    if (_fmutex_create(&__libc_gmtxExec, 0) != 0)
        return -1;

    /*
     * Initialize TLS.
     */
    rc = DosAllocThreadLocalMemory(1, (PULONG*)(void*)&__libc_gpTLS);
    if (rc)
    {
        LIBC_ASSERTM_FAILED("DosAllocThreadLocalMemory() failed. rc=%d\n", rc);
        return -1;
    }

    /*
     * Setup environment (org_environ and _STD(environ))
     */
    rc = _sys_init_environ(ppib->pib_pchenv);
    if (rc)
    {
        LIBC_ASSERTM_FAILED("_sys_init_environ() failed\n");
        return -1;
    }

    /*
     * Get the current process.
     */
    pSelf = __libc_spmSelf();
    if (!pSelf)
    {
        LIBC_ASSERTM_FAILED("__libc_spmSelf() failed\n");
        return -1;
    }

    /*
     * Init long file I/O functions.
     * This is weak, so that it's only linked in when we're building with
     * large file support enabled.
     */
    if (_sys_init_largefileio)
        _sys_init_largefileio();

    /*
     * Init file handles.
     */
    rc = __libc_fhInit();
    if (rc)
    {
        LIBC_ASSERTM_FAILED("__libc_fhInit(%p) failed\n", pSelf->pInherit ? (void *)pSelf->pInherit->pFHBundles : NULL);
        return -1;
    }

    /*
     * Get current time for clock() for use as process startup time.
     */
    _sys_get_clock(&_sys_clock0_ms);
    return 0;
}


/**
 * Get the current MS timestamp.
 * @param   pms     Where to store the current timestamp.
 */
void _sys_get_clock(unsigned long *pms)
{
    ULONG val_ms;
    FS_VAR();

    FS_SAVE_LOAD();
    DosQuerySysInfo(QSV_MS_COUNT, QSV_MS_COUNT, &val_ms, sizeof(val_ms));
    FS_RESTORE();
    *pms = val_ms;
}



#undef  __LIBC_LOG_GROUP
#define __LIBC_LOG_GROUP    __LIBC_LOG_GRP_FORK

_FORK_PARENT1(0xffffffff, initdllForkParent1)

/**
 * Fork callback which transfere the TLM to the child.
 *
 * @returns 0 on success.
 * @returns -errno on failure.
 * @param   pForkHandle     Pointer to fork handle.
 * @param   enmOperation    Fork operation.
 */
int initdllForkParent1(__LIBC_PFORKHANDLE pForkHandle, __LIBC_FORKOP enmOperation)
{
    LIBCLOG_ENTER("pForkHandle=%p enmOperation=%d\n", (void *)pForkHandle, enmOperation);
    int     rc;
    switch (enmOperation)
    {
        case __LIBC_FORK_OP_EXEC_PARENT:
        {
            TLMARGS Args;
            Args.pTLM       = (PULONG)__libc_gpTLS;
            Args.pCurThread = *__libc_gpTLS;
            rc = pForkHandle->pfnInvoke(pForkHandle, initdllForkTLM, &Args, sizeof(Args));
            break;
        }

        default:
            rc = 0;
            break;
    }

    LIBCLOG_RETURN_INT(rc);
}


_FORK_CHILD1(0xffffffff, initdllForkChild1)

/**
 * Fork callback which updates the thread structure in the child.
 *
 * @returns 0 on success.
 * @returns -errno on failure.
 * @param   pForkHandle     Pointer to fork handle.
 * @param   enmOperation    Fork operation.
 */
static int initdllForkChild1(__LIBC_PFORKHANDLE pForkHandle, __LIBC_FORKOP enmOperation)
{
    LIBCLOG_ENTER("pForkHandle=%p enmOperation=%d\n", (void *)pForkHandle, enmOperation);
    int     rc;
    switch (enmOperation)
    {
        case __LIBC_FORK_OP_FORK_CHILD:
        {
            LIBCLOG_MSG("Adjusts thread nesting level. from %d to %d\n", (*__libc_gpTLS)->cDefLoggerDepth,
                        (*__libc_gpTLS)->cDefLoggerDepth - 2);
            (*__libc_gpTLS)->cDefLoggerDepth -= 2;
            rc = 0;
            break;
        }

        default:
            rc = 0;
            break;
    }

    LIBCLOG_RETURN_INT(rc);
}


/**
 * Callback which allocates the TLM entry which the parent is using.
 * and initializes it with the pointer to the thread used by the
 * parent. The global variable is not set, we must wait on the
 * data segment and heap duplication there.
 *
 * @returns 0 on success.
 * @returns -errno on failure.
 * @param   pForkHandle     Pointer to fork handle.
 * @param   pvArg           Pointer to a TLMARGS structure.
 * @param   cbArg           Size of argument pointed to by pvArg.
 */
static int initdllForkTLM(__LIBC_PFORKHANDLE pForkHandle, void *pvArg, size_t cbArg)
{
    LIBCLOG_ENTER("pForkHandle=%p pvArg=%p cbArg=%d\n", (void *)pForkHandle, pvArg, cbArg);
    PTLMARGS    pArgs = (PTLMARGS)pvArg;
    int         rc = 0;
    PULONG      apulTLM[64];
    int         iTLM;
    LIBC_ASSERT(cbArg == sizeof(TLMARGS));

    for (iTLM = 0; iTLM < sizeof(apulTLM) / sizeof(apulTLM[0]); iTLM++)
    {
        /*
         * Allocate.
         */
        rc = DosAllocThreadLocalMemory(1, &apulTLM[iTLM]);
        if (rc)
            break;

        /*
         * The right one?
         */
        if (apulTLM[iTLM] == pArgs->pTLM)
        {
            *apulTLM[iTLM] = (ULONG)pArgs->pCurThread;
            break;
        }
    }

    /*
     * Cleanup.
     */
    while (iTLM-- > 0)
        DosFreeThreadLocalMemory(apulTLM[iTLM]);

    if (!rc)
        LIBCLOG_RETURN_INT(0);
    LIBCLOG_RETURN_INT(-ENOMEM);
}

