/* utimes.c (emx+gcc) -- Copyright (c) 1990-2000 by Eberhard Mattes */

#include "libc-alias.h"
#include <time.h>
#include <sys/time.h>
#include <emx/time.h>
#include <emx/syscalls.h>

int _STD(utimes) (const char *name, const struct timeval *tvp)
{
  struct timeval tv[2];
  time_t tmp;

  if (tvp == NULL)
    {
      tv[0].tv_sec = tv[1].tv_sec = time (NULL);
      tv[0].tv_usec = tv[1].tv_usec = 0;
    }
  else
    {
      tv[0] = tvp[0];
      tv[1] = tvp[1];
    }
  if (!_tzset_flag) _tzset ();
  tmp = tv[0].tv_sec; _gmt2loc (&tmp); tv[0].tv_sec = tmp;
  tmp = tv[1].tv_sec; _gmt2loc (&tmp); tv[1].tv_sec = tmp;
  return __utimes (name, tv);
}
