/* setmode.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <io.h>
#include <fcntl.h>
#include <errno.h>
#include <emx/io.h>

int _STD(setmode) (int handle, int mode)
{
  int old_mode, *pflags;

  if ((pflags = _fd_flags (handle)) == NULL)
    {
      errno = EBADF;
      return -1;
    }
  old_mode = ((*pflags & O_TEXT) ? O_TEXT : O_BINARY);
  if (mode == O_BINARY)
    *pflags &= ~O_TEXT;
  else if (mode == O_TEXT)
    *pflags |= O_TEXT;
  else
    {
      errno = EINVAL;
      return -1;
    }
  return old_mode;
}
