/* eof.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <io.h>
#include <errno.h>
#include <emx/io.h>

int _STD(eof) (int handle)
{
  int *pflags;
  long cur, len;

  if ((pflags = _fd_flags (handle)) == NULL)
    {
      errno = EBADF;
      return -1;
    }
  if (*pflags & F_EOF)          /* Ctrl-Z reached */
    return 1;
  cur = tell (handle);
  if (cur < 0)
    return -1;
  len = _filelength (handle);
  if (len < 0)
    return -1;
  return cur == len;
}
