/ emx_386/syscalls.h (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes

#define ENOMEM     12
#define EINVAL     22

#if !defined (__MT__)

/* Return 0 if NC, set errno from EAX and return -1 if CY. */

#define SET_0 \
        jb      8f ;\
        xorl    %eax, %eax ;\
        jmp     9f ;\
        ALIGN ;\
8:      movl    %eax, _errno ;\
        movl    $-1, %eax ;\
        ALIGN ;\
9:

/* Return EAX if NC, set errno from EAX and return -1 if CY. */

#define SET_EAX \
        jnb     9f ;\
        movl    %eax, _errno ;\
        movl    $-1, %eax ;\
        ALIGN ;\
9:

/* Set errno from ECX if non-zero. */

#define SET_ERRNO_ECX \
        jecxz   9f ;\
        movl    %ecx, _errno ;\
        ALIGN ;\
9:

/* Set errno from x (constant or any register) */

#define SET_ERRNO(x) \
        movl    x, _errno

#else

/* Return 0 if NC, set errno from EAX and return -1 if CY. */

#define SET_0 \
        jb      8f ;\
        xorl    %eax, %eax ;\
        jmp     9f ;\
        ALIGN ;\
8:      pushl   %eax ;\
        call    __errno ;\
        popl    (%eax) ;\
        movl    $-1, %eax ;\
        ALIGN ;\
9:

/* Return EAX if NC, set errno from EAX and return -1 if CY. */

#define SET_EAX \
        jnb     9f ;\
        pushl   %eax ;\
        call    __errno ;\
        popl    (%eax) ;\
        movl    $-1, %eax ;\
        ALIGN ;\
9:

/* Set errno from ECX if non-zero. */

#define SET_ERRNO_ECX \
        jecxz   9f ;\
        pushl   %eax ;\
        pushl   %ecx ;\
        call    __errno ;\
        popl    (%eax) ;\
        popl    %eax ;\
        ALIGN ;\
9:

/* Set errno from x (constant or any register) */

#define SET_ERRNO(x) \
        pushl   x ;\
        call    __errno ;\
        popl    (%eax)

#endif
