/* chsize.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <string.h>
#include <io.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>

int _STD(chsize) (int handle, off_t length)
{
  PLIBCFH   pFH;
  off_t n;

  pFH = __libc_FH(handle);
  if (   !pFH
      || (pFH->fFlags & F_DEV)
      || pFH->pOps)
    {
      errno = EBADF;
      return -1;
    }
  n = __lseek (handle, 0, SEEK_END);
  if (n == -1)
    return -1;
  if (__chsize (handle, length) != 0)
    return -1;
  if (n < length)
    {
      off_t i;
      int   j;
      char  zeros[4096];
      bzero (zeros, sizeof (zeros));
      if (__lseek (handle, n, SEEK_SET) == -1)
        return -1;
      while (n < length)
        {
          i = length - n;
          if (i > sizeof (zeros))
            i = sizeof (zeros);
          j = __write (handle, zeros, i);
          if (j == -1)
            return -1;
          if (j == 0)
            {
              errno = ENOSPC;
              return -1;
            }
          n += j;
        }
    }
  return 0;
}
