/* $Id: __initdll.c 1438 2004-05-04 13:12:44Z bird $ */
/** @file

    Dynamic library low-level initialization routine.

    Copyright (c) 1992-1998 by Eberhard Mattes
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    This routine is called from dll0.o. It should perform
    all kinds of low-level initialization required by a DLL.
*/


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#define INCL_DOS
#include <os2emx.h>
#define _osmajor __osminor
#define _osminor __osminor
#include <stdlib.h>
#undef _osmajor
#undef _osminor
#include <string.h>
#include <sys/builtin.h>
#include <sys/fmutex.h>
#include <emx/startup.h>
#include <emx/syscalls.h>
#include <emx/umalloc.h>
#include <alloca.h>
#include "syscalls.h"
#include <InnoTekLIBC/thread.h>

/* Make this function an weak external. */
#pragma weak __init_largefileio


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
__LIBC_PPTHREAD     __libc_gpTLS;

extern unsigned char _osminor;
extern unsigned char _osmajor;


/**
 * Common init code for crt0 and dll0.
 * This should perhaps be a part of _CRT_init.
 */
int __init_dll(int fDefaultHeapInHighMem)
{
    ULONG   aul[2];
    ULONG   rc;
    PTIB    ptib;
    PPIB    ppib;
    static int initialized = 0;

    /*
     * Heap voting.
     */
    __libc_HeapVote(fDefaultHeapInHighMem);

    /*
     * The rest must only be executed once.
     */
    if (initialized)
        return 0;
    initialized = 1;

    /*
     * Initialize _osmajor and _osminor.
     */
    DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_MINOR, &aul[0], sizeof(aul));
    _osminor = (unsigned char)aul[1];
    _osmajor = (unsigned char)aul[0];

    /*
     * Check for high memory (>512MB) support.
     */
    _sys_gcbVirtualAddressLimit = 0;
    if (    !DosQuerySysInfo(QSV_VIRTUALADDRESSLIMIT, QSV_VIRTUALADDRESSLIMIT, &aul[0], sizeof(aul[0]))
        &&  aul[0] > 512
        &&  (   (_osmajor == 20 && _osminor >= 40)
             || _osmajor > 20 /* yeah, sure! */) )
        _sys_gcbVirtualAddressLimit = aul[0] * 1024*1024;

    /*
     * Get the process ID and parent process ID.
     * This is also required for (stand-alone) DLLs. At least, we need ptib
     * and ppib.
     */
    /** @todo This must be replaced by the fast info block code from Odin/kLib. */
    rc = DosGetInfoBlocks(&ptib, &ppib);
    if (rc != 0)
        return -1;
    _sys_pid = ppib->pib_ulpid;
    _sys_ppid = ppib->pib_ulppid;

    /*
     * Initialize the heap semaphores.
     */
    if (_fmutex_create(&_sys_heap_fmutex, 0) != 0)
        return -1;
    if (_fmutex_create(&_sys_gmtxHimem, 0) != 0)
        return -1;

    /*
     * Initialize TLS.
     */
    if (!__libc_gpTLS)                  /* !paranoia! */
    {
        rc = DosAllocThreadLocalMemory(1, (PULONG*)&__libc_gpTLS);
        if (rc)
            return -1;
    }

    /*
     * Setup environment (org_environ and _STD(environ))
     */
    rc = _sys_init_environ(ppib->pib_pchenv);
    if (rc)
        return -1;

    /*
     * Init long file I/O functions.
     * This is weak, so that it's only linked in when we're building with
     * large file support enabled.
     */
    if (_sys_init_largefileio)
        _sys_init_largefileio();

    /*
     * Init file handles.
     */
    rc = _sys_init_filehandles();
    if (rc)
        return -1;

    /*
     * Get current time for clock() for use as process startup time.
     */
    _sys_get_clock(&_sys_clock0_ms);
    return 0;
}

