/* $Id: tls.c 1384 2004-04-26 00:10:35Z bird $ */
/** @file
 *
 * LIBC tls tests.
 *
 * Copyright (c) 2004 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of LIBC.
 *
 * LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <InnoTekLIBC/thread.h>

#include <stdio.h>



int main()
{
    int     cErrors = 0;
    int     cTLSes = 0;
    int     aiTLSes[1024];
    int     i;

    /*
     * Allocate the maximum number of TLSes checking that
     * the limit checking works.
     */
    do
    {
        aiTLSes[cTLSes] = __libc_TLSAlloc();
        if (aiTLSes[cTLSes] < 0)
            break;
        cTLSes++;
    } while (cTLSes < 1024);
    printf("tls: info: max=%d\n", cTLSes);
    if (cTLSes < __LIBC_TLS_MAX)
    {
        printf("tls: error: cTLSes != max (%d != %d)\n", cTLSes, __LIBC_TLS_MAX);
        cErrors++;
    }
    /* check for duplicates */
    for (i = 0; i <  cTLSes; i++)
    {
        int j;
        for (j = 0; j < cTLSes; j++)
        {
            if (i != j && aiTLSes[i] == aiTLSes[j])
            {
                printf("tls: error: duplicate allocation. i=%d, j=%d, index=%d\n",
                       i, j, aiTLSes[i]);
                cErrors++;
            }
        }
    }

    /*
     * Free the allocated TLSes.
     */
    for (i = 0; i < cTLSes; i++)
    {
        if (__libc_TLSFree(aiTLSes[i]))
        {
            printf("tls: error: failed to free index %d\n", aiTLSes[i]);
            cErrors++;
        }
    }


    /*
     * Test summary
     */
    if (cErrors)
        printf("tls: testcase failed with %d errors\n", cErrors);
    else
        printf("tls: testcase executed successfully\n");
    return cErrors;
}
