/* vsscanf.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <stdio.h>
#include <stdarg.h>
#include <limits.h>
#include <string.h>
#include <emx/io.h>

int _STD(vsscanf) (const char *buffer, const char *format, va_list arg_ptr)
{
  FILE trick;
  int result;

  trick._buffer = (char *)buffer;             /* const -> non-const */
  trick._ptr = (char *)buffer;                /* const -> non-const */
  trick._rcount = strlen (buffer);
  trick._wcount = 0;
  trick._handle = -1;
  trick._flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOREAD;
  trick._buf_size = INT_MAX;
  trick._flush = NULL;
  trick._ungetc_count = 0;
  trick._mbstate = 0;
  _rmutex_dummy(&trick.__u.__rsem);
  result = _input (&trick, format, arg_ptr);
  return result;
}
