/* sys/dup.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
                       -- Copyright (c) 2003 by Knut St. Osmunden */

#include "libc-alias.h"
#define INCL_FSMACROS
#define INCL_ERRORS
#include <os2emx.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __dup(int fh)
{
    PLIBCFH     pFH;
    int         fhNew;
    ULONG       rc;

    /*
     * Get filehandle.
     */
    pFH = __libc_FH(fh);
    if (!pFH)
    {
        errno = EBADF;
        return -1;
    }

    /*
     * Choose path.
     */
    if (!pFH->pOps)
    {
        int     cExpandRetries;
        HFILE   hNew;
        FS_VAR();
        FS_SAVE_LOAD();
        for (cExpandRetries = 0;;)
        {
            hNew = ~0;
            rc = DosDupHandle(fh, &hNew);
            if (rc != ERROR_TOO_MANY_OPEN_FILES)
                break;
            if (cExpandRetries++ >= 3)
                break;
            /* autoincrement. */
            __libc_FHMoreHandles();
        }   /* ... retry 3 times ... */
        FS_RESTORE();
        fhNew = (int)hNew;
        if (!rc)
        {
            PLIBCFH pFHNew;
            rc = __libc_FHAllocate(hNew, pFH->fFlags, sizeof(LIBCFH), NULL, &pFHNew, NULL);
            if (!rc)
            {
                pFHNew->fFlags      = pFH->fFlags;
                pFHNew->iLookAhead  = pFH->iLookAhead;
            }
            else
                DosClose(hNew);
        }
    }
    else
    {
        fhNew = -1; /* any handle */
        rc = pFH->pOps->pfnDuplicate(pFH, fh, &fhNew);
    }

    /*
     * Done.
     */
    if (rc != 0)
    {
        _sys_set_errno(rc);
        return -1;
    }
    return fhNew;
}
