/* _newstre.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes
                        -- Copyright (c) 2003 by Knut St. Osmundsen */

#include "libc-alias.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/umalloc.h>
#include <emx/io.h>

#define INC     32
#define ALIGN(p, a) (((unsigned long)(p) + (a) - 1) & ~((a) - 1))

FILE *_newstream (void)
{
    int                 i;
    struct streamvec   *pSV;
    struct streamvec   *pSVNew;

    /*
     * Search thru the list of streams.
     */
    STREAMV_LOCK;
    for (pSV = _streamvec_head; pSV != NULL; pSV = pSV->next)
    {
        for (i = 0; i < pSV->n; ++i)
        {
            if (!(pSV->vec[i]._flags & (_IOOPEN|_IONEW)))
            {
                pSV->vec[i]._flags = _IONEW;
                STREAMV_UNLOCK;
                return &pSV->vec[i];
            }
        }
    }
    STREAMV_UNLOCK;

    /*
     * Enlarge our table.
     * (As the entries must not move, we add another segment.)
     */
    pSVNew = _hcalloc(1, sizeof(*pSV) + 15
                      + INC * sizeof(struct _FILE)
                      + 15
                      + INC * sizeof(struct _file2));
    if (pSVNew)
    {
        struct _FILE       *pFile;
        struct _file2      *pFile2;

        /*
         * Init the structures in the segment.
         * Remember everything is ZEROed by calloc()!
         */
        pSVNew->vec = pFile = (struct _FILE  *)ALIGN(pSVNew + 1, 16);
        pFile2              = (struct _file2 *)ALIGN(&pFile[INC], 16);
        pSVNew->vec         = pFile;
        pSVNew->n           = INC;
        for (i = 0; i < INC; i++, pFile++, pFile2++)
        {
            pFile2->owner = pFile; /* obsolete? */
            pFile->_more = pFile2;
        }

        /*
         * Allocate the first one.
         */
        pFile = &pSVNew->vec[0];
        pFile->_flags = _IONEW;

        /*
         * Insert the new chunk.
         */
        STREAMV_LOCK;
        if (_streamvec_head)
        {
            for (pSV = _streamvec_head; pSV; pSV = pSV->next)
                if (!pSV->next)
                {
                    pSV->next = pSVNew;
                    break;
                }
        }
        else
            /* Someone fopen'ed something before streams were initated. */
            _streamvec_head = pSVNew;
        STREAMV_UNLOCK;
        return pFile;
    }

    return NULL;
}

/**
 * This used to set the _more member, but now it only create the mutex and
 * init _mbstate.
 *
 * @returns 0 on success.
 * @returns -1 on failure
 * @param   stream  Stream to init.
 * @param   lock    Ignored.
 */
int _setmore(FILE *stream, int lock)
{
    /*
     * Now this isn't so much work any longer, the streams are
     * allocated with a more buffer by default now.
     * All we gotta do is init _mbstate and create the mutex.
     */
    stream->_mbstate = 0;
    if (_rmutex_create(&stream->_more->rsem, 0) != 0)
    {
        /* free the stream */
        stream->_flags = 0;
        lock = lock;
        return -1;
    }
    return 0;
}

/**
 * This is used when creating a special stream for instance in vsprintf().
 *
 * @param   stream  Special stream.
 * @param   more    Dummy more block
 */
void _setdummymore (FILE *stream, struct _file2 *more)
{
    stream->_mbstate = 0;
    stream->_more = more;
    more->owner = stream;
    _rmutex_dummy(&more->rsem);
}


/**
 * Closes a stream freeing the associated mutex semaphore.
 *
 * @param   stream  Stream to close.
 */
void _closestream(FILE *stream)
{
    if (    stream->_more != NULL
        &&  stream->_more->owner == stream) /* paranoia */
        _rmutex_close(&stream->_more->rsem);
    stream->_flags = 0;
}
