/* sys/open.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   Copyright (c) 2003 Dimitry Froloff
   Copyright (c) 2003 knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_DOSERRORS
#define INCL_FSMACROS
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <emx/syscalls.h>
#include <emx/io.h>
#include <alloca.h>
#include "syscalls.h"
#include <InnoTekLIBC/pathrewrite.h>
#define __LIBC_LOG_GROUP __LIBC_LOG_GRP_BACK_IO
#include <InnoTekLIBC/logstrict.h>

int __open(const char *pszFile, int flags, off_t cbInitial, unsigned fLibc, PLIBCFH *ppFH)
{
    LIBCLOG_ENTER("pszFile=%s flags=%#x cbInitial=%lld fLibc=%#x ppFH=%p\n",
                  pszFile, flags, cbInitial, fLibc, (void*)ppFH);
    ULONG   rc;
    ULONG   flOpenMode;
    ULONG   flOpenFlags;
    ULONG   flAttr;
    ULONG   ulAction;
    HFILE   hFile;
    int     cch;
    int     failed_open_errno;
    FS_VAR();


    /*
     * Rewrite the specified file path.
     */
    cch = __libc_PathRewrite(pszFile, NULL, 0);
    if (cch > 0)
    {
        char *pszRewritten = alloca(cch);
        if (!pszRewritten)
        {
            errno = ENOMEM;
            LIBCLOG_RETURN_INT(-1);
        }
        cch = __libc_PathRewrite(pszFile, pszRewritten, cch);
        if (cch > 0)
            pszFile = pszRewritten;
        /* else happens when someone changes the rules between the two calls. */
        else if (cch < 0)
        {
            errno = EAGAIN;             /* non-standard, I'm sure. */
            LIBCLOG_RETURN_INT(-1);
        }
    }

    /*
     * Extract the access mode and sharing mode bits.
     */
    flOpenMode = flags & 0x77;

    /*
     * File O_NOINHERIT and O_SYNC.
     */
    if (flags & _SO_NOINHERIT)
        flOpenMode |= OPEN_FLAGS_NOINHERIT;
    if (flags & _SO_SYNC)
        flOpenMode |= OPEN_FLAGS_WRITE_THROUGH;

    /*
     * Extract the file flAttribute bits.
     */
    flAttr = (flags >> 8) & 0xff;
    if (_sys_umask & 0200)
        flAttr |= FILE_READONLY;

    /*
     * Translate ERROR_OPEN_FAILED to ENOENT unless O_EXCL is set (see below).
     */
    failed_open_errno = ENOENT;

    /*
     * Compute `flOpenFlags' depending on `flags'.  Note that _SO_CREAT is
     * set for O_CREAT.
     */
    if (flags & _SO_CREAT)
    {
        if (flags & _SO_EXCL)
        {
            flOpenFlags = OPEN_ACTION_FAIL_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
            failed_open_errno = EEXIST;
        }
        else if (flags & _SO_TRUNC)
            flOpenFlags = OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
        else
            flOpenFlags = OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
    }
    else if (flags & _SO_TRUNC)
        flOpenFlags = OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW;
    else
        flOpenFlags = OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW;

    if (!(flags & _SO_SIZE))
        cbInitial = 0;

    /*
     * Try to open the file.
     */
    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosOpenL)
    {
        LONGLONG cbInitialTmp = cbInitial;
        int     cch = strlen(pszFile);
        char *  pszFile_safe = alloca(cch + 1);
        if (pszFile_safe)
        {
            strcpy(pszFile_safe, pszFile);
            rc = __pfnDosOpenL((PCSZ)pszFile_safe, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
        }
        else
            rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    else
    {
        ULONG cbInitialTmp = (ULONG)cbInitial;
        if (cbInitial > LONG_MAX)
        {
            FS_RESTORE();
            errno = EOVERFLOW;
            LIBCLOG_RETURN_INT(-1);
        }
        rc = DosOpen((PCSZ)pszFile, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
    }
#else
    {
        ULONG cbInitialTmp = cbInitial;
        rc = DosOpen((PCSZ)pszFile, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
    }
#endif

    if (!rc)
    {
        ULONG   fulType;
        ULONG   fulDevFlags;

        /*
         * Figure the handle type.
         */
        rc = DosQueryHType(hFile, &fulType, &fulDevFlags);
        if (!rc)
        {
            switch (fulType & 0xff)
            {
                default: /* paranoia */
                case HANDTYPE_FILE:
                    fLibc |= F_FILE;
                    break;
                case HANDTYPE_DEVICE:
                    fLibc |= F_DEV;
                    break;
                case HANDTYPE_PIPE:
                    fLibc |= F_PIPE;
                    break;
            }

            /*
             * Register the handle.
             */
            rc = __libc_FHAllocate(hFile, fLibc, sizeof(LIBCFH), NULL, ppFH, NULL);
            LIBCLOG_MSG("hFile=%#lx fLibc=%#x fulType=%#lx ulAction=%lu\n",
                        hFile, fLibc, fulType, ulAction);
        }

        if (rc)
            DosClose(hFile);
    }
    FS_RESTORE();

    /*
     * Handle any errors.
     */
    if (rc)
    {
        if (rc == ERROR_OPEN_FAILED)
            errno = failed_open_errno;
        else
            _sys_set_errno(rc);
        LIBCLOG_RETURN_INT(-1);
    }
    return hFile;
}
